<?php
/**
 * Renders the Composer tab content.
 * @package MonzurMailer
 */
if ( ! defined( 'ABSPATH' ) ) exit;

$recipient_options = monzurmailer_get_recipient_options();
$wp_roles          = monzurmailer_get_wordpress_roles();
$email_templates   = get_option( 'monzurmailer_email_templates', [] );
?>
<div class="wrap monzurmailer-wrap">
    <form method="post" id="monzurmailer-compose-form" class="monzurmailer-form">
        <input type="hidden" name="form_action" value="send_email">
        <div class="monzurmailer-notice-area"></div>
        <table class="form-table">
            <tbody>
                <tr>
                    <th scope="row"><label for="monzurmailer_recipient_type"><?php esc_html_e( 'Recipient Type', 'monzurmailer' ); ?></label></th>
                    <td>
                        <select name="monzurmailer_recipient_type" id="monzurmailer_recipient_type">
                            <?php foreach ( $recipient_options as $value => $label ) : ?>
                                <option value="<?php echo esc_attr( $value ); ?>"><?php echo esc_html( $label ); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
                <tr id="monzurmailer_manual_recipient_container" style="display: none;">
                    <th scope="row"><label for="monzurmailer_to_manual"><?php esc_html_e( 'Recipient Email(s)', 'monzurmailer' ); ?></label></th>
                    <td><textarea name="monzurmailer_to_manual" id="monzurmailer_to_manual" rows="2" class="large-text" placeholder="<?php esc_attr_e( 'Enter emails, separated by commas.', 'monzurmailer' ); ?>"></textarea></td>
                </tr>
                <tr id="monzurmailer_wp_role_select_container" style="display: none;">
                    <th scope="row"><label for="monzurmailer_wp_role"><?php esc_html_e( 'Select Role', 'monzurmailer' ); ?></label></th>
                    <td>
                        <select name="monzurmailer_wp_role" id="monzurmailer_wp_role">
                            <option value=""><?php esc_html_e( '-- Select a Role --', 'monzurmailer' ); ?></option>
                            <?php foreach ( $wp_roles as $role_key => $role_details ) : ?>
                                <option value="<?php echo esc_attr( $role_key ); ?>"><?php echo esc_html( $role_details['name'] ); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
                <?php if ( ! empty( $email_templates ) ) : ?>
                <tr>
                    <th scope="row"><label for="monzurmailer_template_select"><?php esc_html_e( 'Load Template', 'monzurmailer' ); ?></label></th>
                    <td>
                        <select id="monzurmailer_template_select">
                            <option value=""><?php esc_html_e( '-- Choose a Template --', 'monzurmailer' ); ?></option>
                            <?php foreach ( $email_templates as $index => $template ) : ?>
                                <option value="<?php echo esc_attr( $index ); ?>"><?php echo esc_html( $template['title'] ?? 'Untitled' ); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
                <?php endif; ?>
                <tr>
                    <th scope="row"><label for="monzurmailer_subject"><?php esc_html_e( 'Subject', 'monzurmailer' ); ?></label></th>
                    <td><input type="text" name="monzurmailer_subject" id="monzurmailer_subject" class="large-text" required></td>
                </tr>
            </tbody>
        </table>
        <div class="monzurmailer-editor-container">
            <h3><?php esc_html_e( 'Message', 'monzurmailer' ); ?></h3>
            <?php wp_editor( '', 'monzurmailer_message', [ 'textarea_name' => 'monzurmailer_message', 'media_buttons' => true, 'textarea_rows' => 15 ] ); ?>
        </div>
        <?php submit_button( __( 'Send Email', 'monzurmailer' ), 'primary large' ); ?>
    </form>
</div>