<?php
/**
 * Renders the main admin page structure with navigation tabs.
 * @package MonzurMailer
 */
if ( ! defined( 'ABSPATH' ) ) exit;

function monzurmailer_render_admin_page() {
    ?>
    <div class="wrap monzurmailer-container">
        <h1><?php esc_html_e( 'Monzur Mailer- Secure and Lightweight SMTP Dashboard Mailer', 'monzurmailer' ); ?></h1>
        <nav class="nav-tab-wrapper">
            <a href="#" data-tab="composer" class="nav-tab nav-tab-active"><span class="dashicons dashicons-edit"></span> <?php esc_html_e( 'Composer', 'monzurmailer' ); ?></a>
            <a href="#" data-tab="settings" class="nav-tab"><span class="dashicons dashicons-admin-settings"></span> <?php esc_html_e( 'Settings', 'monzurmailer' ); ?></a>
            <a href="#" data-tab="logs" class="nav-tab"><span class="dashicons dashicons-list-view"></span> <?php esc_html_e( 'Email Logs', 'monzurmailer' ); ?></a>
            <a href="#" data-tab="templates" class="nav-tab"><span class="dashicons dashicons-database"></span> <?php esc_html_e( 'Templates', 'monzurmailer' ); ?></a>
        </nav>
        <div class="monzurmailer-tabs-content">
            <div id="composer" class="monzurmailer-tab-content">
                <?php require_once MONZURMAILER_PLUGIN_DIR . 'admin/compose-page.php'; ?>
            </div>
            <div id="settings" class="monzurmailer-tab-content" style="display:none;">
                <?php require_once MONZURMAILER_PLUGIN_DIR . 'admin/settings-page.php'; ?>
            </div>
            <div id="logs" class="monzurmailer-tab-content" style="display:none;">
                <?php require_once MONZURMAILER_PLUGIN_DIR . 'admin/logs-page.php'; ?>
            </div>
            <div id="templates" class="monzurmailer-tab-content" style="display:none;">
                <?php require_once MONZURMAILER_PLUGIN_DIR . 'admin/templates-page.php'; ?>
            </div>
        </div>
    </div>
    <?php
}