import { Button } from '@wordpress/components';
import { useNotificationContext } from './../context/NotificationContext';
import AddEditModal from './AddEditModal';

export default function NotificationHeader() {
    const { isModalOpen, openModal } = useNotificationContext();
    return (
        <div className="monitori-notification-header">
            <h1>Notifications</h1>
            <Button variant="primary" onClick={() => openModal()}>
                Add new
            </Button>

            {isModalOpen && (
                <AddEditModal />
            )}
        </div>
    );
}