
import React from "react";
import { createRoot } from "react-dom/client";

import { NotificationProvider } from './context/NotificationContext';
import NotificationList from './components/NotificationList';

import "../scss/admin.scss";

function App({ nonce }) {
  return (
    <NotificationProvider nonce={nonce}>
      <NotificationList />
    </NotificationProvider>
  );
}

const container = document.getElementById("monitori-notifications");

if (container) {
  const root = createRoot(container);
  root.render(<App nonce={container?.dataset?.nonce} />);
}