<?php

/**
 * Plugin Name:       Monitori
 * Description:       A wp plugin
 * Requires at least: 5.9
 * Requires PHP:      8.0
 * Version:           0.2.5
 * Author:            Monitori
 * License:           GPLv2 or later
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       monitori
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly
}
define( 'MONITORI_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'MONITORI_ASSET_VERSION', '0.2.5' );
if ( !defined( 'MONITORI_MIDDLEWARE_URL' ) ) {
    define( 'MONITORI_MIDDLEWARE_URL', 'https://mw.monitori.app' );
}
if ( !function_exists( 'monitori_console_log' ) ) {
    function monitori_console_log(  $data  ) {
        if ( defined( 'WP_DEBUG' ) && WP_DEBUG === true && defined( 'MONITORI_DEBUG' ) && MONITORI_DEBUG === true ) {
            $caller = debug_backtrace( DEBUG_BACKTRACE_IGNORE_ARGS, 2 )[1]['function'] ?? 'global';
            error_log( wp_json_encode( [
                'data'   => $data,
                'caller' => $caller,
            ], JSON_PRETTY_PRINT ) );
        }
    }

}
require_once MONITORI_PLUGIN_DIR . '/vendor/autoload.php';
if ( !function_exists( 'monitori_fs' ) ) {
    // Create a helper function for easy SDK access.
    function monitori_fs() {
        global $monitori_fs;
        if ( !isset( $monitori_fs ) ) {
            // Include Freemius SDK.
            // require_once dirname(__FILE__) . '/vendor/freemius/wordpress-sdk/start.php';
            $monitori_fs = fs_dynamic_init( array(
                'id'             => '16605',
                'slug'           => 'monitori',
                'type'           => 'plugin',
                'public_key'     => 'pk_3cdba11750865a3841b3b714cb9fc',
                'is_premium'     => false,
                'premium_suffix' => 'Premium',
                'has_addons'     => false,
                'has_paid_plans' => true,
                'trial'          => array(
                    'days'               => 14,
                    'is_require_payment' => true,
                ),
                'menu'           => array(
                    'slug'    => 'monitori',
                    'contact' => false,
                    'support' => false,
                ),
                'is_live'        => true,
            ) );
        }
        return $monitori_fs;
    }

    // Init Freemius.
    monitori_fs();
    // Signal that SDK was initiated.
    do_action( 'monitori_fs_loaded' );
}
require_once MONITORI_PLUGIN_DIR . 'inc/class-db.php';
require_once MONITORI_PLUGIN_DIR . 'inc/delivery-channels/class-discord-setup.php';
require_once MONITORI_PLUGIN_DIR . 'inc/delivery-channels/class-slack-setup.php';
require_once MONITORI_PLUGIN_DIR . 'inc/delivery-channels/class-email-setup.php';
require_once MONITORI_PLUGIN_DIR . 'inc/class-notifier.php';
require_once MONITORI_PLUGIN_DIR . 'inc/class-ajax.php';
require_once MONITORI_PLUGIN_DIR . 'inc/class-admin-edit-ui.php';
require_once MONITORI_PLUGIN_DIR . 'inc/class-admin-dashboard-ui.php';
require_once MONITORI_PLUGIN_DIR . 'inc/class-event-manager.php';
require_once MONITORI_PLUGIN_DIR . 'inc/class-metric-manager.php';
require_once MONITORI_PLUGIN_DIR . 'inc/class-setup.php';
require_once MONITORI_PLUGIN_DIR . 'inc/integrations/class-base-integration.php';
require_once MONITORI_PLUGIN_DIR . 'inc/integrations/class-woocommerce-integration.php';
require_once MONITORI_PLUGIN_DIR . 'inc/integrations/class-corewp-integration.php';
new Monitori\Setup();
new \Monitori\Woocommerce_Event_Integration();
new \Monitori\Woocommerce_Metric_Integration();
new \Monitori\CoreWP_Event_Integration();
new \Monitori\Ajax_Notifications();
register_activation_hook( __FILE__, array('\\Monitori\\Setup', 'plugin_activation') );