<?php

namespace Monitori;

class WPForms_Event_Integration extends \Monitori\Base_Event_Integration
{
    public $handler = 'wpforms';

    /**
     * Define WPForms Event Types
     */
    public function get_event_types()
    {
        return [
            // Successful Form Submission
            'wpforms_process_complete' => [
                'label'    => __('WPForms: Form Submitted', 'monitori'),
                'category' => $this->handler,
                'args'     => ['fields', 'entry', 'form_data'],
                'args_handler' => function ($args) {
                    $final_args = [];

                    foreach ($args[0] as $item) {
                        if (isset($item['name']) && isset($item['value'])) {
                            $final_args[$item['name']] = $item['value'];
                        }
                    }

                    return $final_args;
                },
                'preview_handler' => function ($args) {
                    return [
                        'Name' => 'John Doe',
                        'Email' => 'test@test.com',
                        'Phone' => '123-333-2222',
                    ];
                }
            ],
        ];
    }

}
