<?php

namespace Monitori;

class GravityForms_Event_Integration extends \Monitori\Base_Event_Integration
{
    public $handler = 'gravityforms';

    /**
     * Define Gravity Forms Event Types
     */
    public function get_event_types()
    {
        return [
            // Successful Form Submission
            'gform_after_submission' => [
                'label'    => __('Gravity Forms: Form submitted', 'monitori'),
                'category' => $this->handler,
                'args'     => [
                    'lead'         => [
                        'type'  => 'object',
                        'label' => 'Lead Data'
                    ],
                    'contact_form' => [
                        'type'  => 'object',
                        'label' => 'Contact Form'
                    ]
                ],
                'args_handler' => function ($args) {
                    return $this->gforms_args_handler($args);
                }
            ],
        ];
    }

    public function gforms_args_handler($args)
    {
        $lead = $args[0];
        $form_instance = $args[1];

        if (empty($form_instance)) {
            return [];
        }

        $final_args = [];

        if (!empty($form_instance['title'])) {
            $final_args['Form Title'] = $form_instance['title'];
        }

        if (!empty($form_instance['id'])) {
            $url                    = admin_url('admin.php?page=gf_edit_forms') . '&id=' . $form_instance['id'];
            $final_args['Form URL'] = "<a href='$url'>View Form</a>";
        }

        if (!empty($lead['id']) && !empty($form_instance['id'])) {
            $entry_url                      = admin_url('admin.php?page=gf_entries') . '&view=entry&id=' . $form_instance['id'] . '&lid=' . $lead['id'] . '&order=ASC&filter=&paged=1&pos=0&field_id=&operator=';
            $final_args['Entry Details:']   = "<a href='$entry_url'>View Entry</a>";
        }

        if (!empty($lead['source_url'])) {
            $source_url                         = $lead['source_url'];
            $final_args['Submission Page:']     = "<a href='$source_url'>$source_url</a>";
        }

        return $final_args;
    }
}
