<?php

namespace Monitori;

use stdClass;

class CF7_Event_Integration extends \Monitori\Base_Event_Integration
{
    public $handler = 'cf7';

    /**
     * Define Contact Form 7: Event Types
     */
    public function get_event_types()
    {
        return [
            'wpcf7_submit' => [
                'label'    => __('Contact Form 7: Form Submitted', 'monitori'),
                'category' => $this->handler,
                'args'     => [
                    'contact_form' => [
                        'type'  => 'object',
                        'label' => 'Contact Form'
                    ],
                ],
                'args_handler' => function ($args) {
                    return $this->form_args_handler($args);
                }
            ],

            'wpcf7_mail_sent' => [
                'label'    => __('Contact Form 7: Email Sent', 'monitori'),
                'category' => $this->handler,
                'args'     => [
                    'contact_form' => [
                        'type'  => 'object',
                        'label' => 'Contact Form'
                    ]
                ],
                'args_handler' => function ($args) {
                    return $this->form_args_handler($args);
                }
            ],

            'wpcf7_mail_failed' => [
                'label'    => __('Contact Form 7: Email Sending Failed', 'monitori'),
                'category' => $this->handler,
                'args'     => [
                    'contact_form' => [
                        'type'  => 'object',
                        'label' => 'Contact Form'
                    ]
                ],
                'args_handler' => function ($args) {
                    return $this->form_args_handler($args);
                }
            ],

            'wpcf7_spam' => [
                'label'    => __('Contact Form 7: Spam Detected', 'monitori'),
                'category' => $this->handler,
            ],
        ];
    }

    public function form_args_handler($args)
    {
        $contact_form_object    = !empty($args[0]) && $args[0] instanceof \WPCF7_ContactForm ? $args[0] : null;

        if (empty($contact_form_object)) {
            return [];
        }

        $title      = !empty($contact_form_object->title()) ? $contact_form_object->title() : null;
        $id         = !empty($contact_form_object->id()) ? $contact_form_object->id() : null;
        $final_args = [];

        if (!empty($title)) {
            $final_args['Contact Form Title'] = $title;
        }

        if (!empty($id)) {
            $url                            = admin_url('admin.php?page=wpcf7') . '&post=' . $id . '&action=edit';
            $final_args['Contact Form URL'] = '<a href="' . $url . '">' . $url . '</a>';
        }

        return $final_args;
    }
}
