<?php

namespace Monitori;

final class Email_Setup
{
    static function send_notification($settings)
    {
        $recipient  = $settings['recipient'] ?? '';
        $subject    = $settings['subject'] ?? '';
        $message    = $settings['message'] ?? '';
        $from       = $settings['from'] ?? '';

        // Headers for plain text email
        $headers = array(
            'Content-Type: text/html; charset=UTF-8',
            'From: ' . $from
        );

        // Send the email
        return wp_mail($recipient, $subject, $message, $headers);
    }

    static function prepare_email_message($hook_label = '', $args = [])
    {
        $message =   '<p>';
        // translators: "You are receiving this email because a notification got triggered: {NAME_OF_THE_EVENT}"
        $message .=  sprintf(__('You are receiving this email because a notification got triggered: %s', 'monitori'), $hook_label);
        $message .=  '</p>';
        $message .=  '<br/>';

        if (!empty($args)) {
            $message .=  '<p>';
            $message .=  __('Details:', 'monitori');
            $message .=  '</p>';

            foreach ($args as $key => $value) {
                $message .=  '<p><strong>' . $key . '</strong>: ' . $value . '<p>';
            }
        }

        return $message;
    }

    static function create_event_notification_subject($hook_label){
        return sprintf(__('Monitori - event triggered: %s', 'monitori'), $hook_label);
    }

    static function create_metric_notification_subject($hook_label, $change_type, $metric_details)
    {
        $change_type_labels         = \Monitori\Base_Metric_Integration::get_metric_change_types();
        $current_change_type_label  = $change_type_labels[$change_type] ?? '';
        $current_change_type_label  = strtolower($current_change_type_label);

        return sprintf(
            // translators: "Monitori: {hook_label} {current_change_type_label} {value}" example: "Monitori: Number of orders decreased by 10"
            __('Monitori: %1$s %2$s %3$s', 'monitori'),
            $hook_label,
            $current_change_type_label,
            $metric_details['value']
        );
    }
}
