<?php

namespace Monitori;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Event_Manager
{
    public function __construct()
    {
        add_action('init', [$this, 'init']);
    }

    public function init()
    {
        $notification_types = self::get_types();

        $notifications_raw = \Monitori\Database::get_notifications_paginated(1, 5000, 'event');

        if (!empty($notifications_raw['notifications'])) {

            foreach ($notifications_raw['notifications'] as $notification) {
                $hook_name              = $notification->event_type;
                $delivery_channels      = json_decode($notification->delivery_channels, true);
                $event_type_details     = !empty($notification_types[$hook_name]) ? $notification_types[$hook_name] : false;
                $accepted_args          = !empty($event_type_details['args']) ? count($event_type_details['args']) : 1;

                if (!$event_type_details) return;

                $is_custom_hook = isset($event_type_details['is_custom_hook']) ? $event_type_details['is_custom_hook'] : false;

                if ($is_custom_hook && is_callable($event_type_details['custom_hook_init'])) {
                    $event_type_details['custom_hook_init']();
                }

                add_action($hook_name, function (...$args) use ($delivery_channels, $hook_name) {

                    static $has_run = false;

                    if (!$has_run) {
                        $has_run = true;

                        $notifier = new \Monitori\Notifier(array(
                            'category'           => 'event',
                            'delivery_channels'  => $delivery_channels,
                            'hook_name'          => $hook_name,
                            'args'               => $args,
                        ));

                        $notifier->send_notifications();
                    }
                }, 10, $accepted_args);
            }
        }
    }


    static function get_types()
    {
        $types = apply_filters('monitori_event_types', []);

        return $types;
    }

    static function get($name)
    {
        $types = self::get_types();

        if (empty($types[$name])) return false;

        return $types[$name];
    }

    static function get_option_values()
    {
        $types = self::get_types();
        $option_values = [];

        foreach ($types as $hook_name => $details) {
            $option_values[$hook_name] = $details['label'];
        }

        return $option_values;
    }

    static function get_preview_details()
    {
        $types = self::get_types();
        $previews = [];

        foreach ($types as $hook_name => $details) {
            if (empty($details['preview_handler'])) {
                continue;
            }
            $preview_handler    = $details['preview_handler'] ?? false;

            if (!is_callable($preview_handler )) {
                continue;
            }

            $the_args = $details['args'] ?? [];

            $previews[$hook_name] = $preview_handler($the_args);
        }

        return $previews;
    }
}
