<?php

namespace Monitori;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

final class Admin_Edit_UI
{
    private static $allowed_platforms = ['slack', 'discord'];

    static function generate_oauth_url($platform = 'slack', $is_api = false)
    {
        $platform = in_array($platform, self::$allowed_platforms, true) ? $platform : 'slack';

        $nextjs_base_url = esc_url_raw(MONITORI_MIDDLEWARE_URL . '/api/' . $platform);

        $current_url = $is_api
            ? admin_url('admin.php?page=monitori-notifications')
            : admin_url('admin.php?page=monitori');

        $encoded_url = urlencode($current_url);

        $nextjs_oauth_url = add_query_arg('wpSite', $encoded_url, $nextjs_base_url);

        return esc_url_raw($nextjs_oauth_url);
    }

    static function generate_disconnect_url($platform = 'slack', $is_api = false)
    {
        $platform = in_array($platform, self::$allowed_platforms, true) ? $platform : 'slack';

        $base_url = $is_api
            ? esc_url_raw(admin_url('admin.php?page=monitori-notifications'))
            : esc_url_raw(admin_url('admin.php?page=monitori'));

        $disconnect_url = add_query_arg('monitori_disconnect_' . $platform, '1', $base_url);

        return esc_url($disconnect_url);
    }
}
