<?php

namespace Monitori;

if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Exit if accessed directly
}
class Admin_Dashboard_UI {
    public function __construct() {
        add_action( 'admin_menu', function () {
            // Add a new menu page
            add_menu_page(
                'Monitori Dashboard',
                'Monitori',
                'manage_options',
                'monitori',
                [$this, 'display_admin_page'],
                plugin_dir_url( dirname( __FILE__ ) ) . '/assets/monitori-admin-icon.svg',
                20
            );
            add_submenu_page(
                'monitori',
                'Notifications',
                'Notifications',
                'manage_options',
                'monitori-notifications',
                array($this, 'render_notification_list_page')
            );
        } );
    }

    public function display_admin_page() {
        ?>
        <div class="wrap">
            <h1><?php 
        esc_html_e( 'Monitori', 'monitori' );
        ?></h1>

            <?php 
        $this->show_welcome_section();
        ?>

        </div>
    <?php 
    }

    public function show_welcome_section() {
        ?>

        <div class="anyf-welcome">
            <div class="anyf-welcome__header">
                <div class="anyf-welcome__header-content">
                    <h2><?php 
        esc_html_e( 'Welcome to Monitori!', 'monitori' );
        ?></h2>
                    <p><?php 
        esc_html_e( 'Thank you for choosing Monitori to supercharge your notifications! 🚀 We’re thrilled to have you on board. With our powerful and customizable notification system, you’ll never miss a beat.', 'monitori' );
        ?></p>

                </div>

                <div class="anyf-welcome__header-btn">
                    <a href="<?php 
        echo esc_url( admin_url( 'admin.php?page=monitori-notifications&action=new' ) );
        ?>" class="button button-primary button-hero">
                        <?php 
        esc_html_e( 'Add new notification', 'monitori' );
        ?>
                    </a>
                </div>
            </div>

            <hr />

            <?php 
        $this->show_recent_notifications();
        ?>

            <?php 
        $this->show_delivery_channels();
        ?>

            <?php 
        $this->show_footer();
        ?>

        </div>

    <?php 
    }

    public function show_recent_notifications() {
        $notifications_raw = \Monitori\Database::get_notifications_paginated( 1, 3, 'all' );
        ?>

        <div class="anyf-recent-notifcation">
            <h3><?php 
        esc_html_e( 'Recent Notifications', 'monitori' );
        ?></h3>
            <table class="wp-list-table widefat fixed striped table-view-list posts">
                <tbody id="the-list">
                    <?php 
        if ( !empty( $notifications_raw['notifications'] ) ) {
            ?>
                        <?php 
            foreach ( $notifications_raw['notifications'] as $notification ) {
                ?>
                            <tr id="post-<?php 
                echo esc_attr( $notification->id );
                ?>" class="iedit author-self level-0 post-<?php 
                echo esc_attr( $notification->id );
                ?> status-publish hentry">
                                <td class="title column-title has-row-actions column-primary page-title">
                                    <strong>
                                        <a class="row-title" href="<?php 
                echo esc_url( admin_url( 'admin.php?page=monitori-notifications&action=edit&id=' . $notification->id ) );
                ?>">
                                            <?php 
                echo esc_html( $notification->name );
                ?>
                                        </a>
                                    </strong>
                                </td>
                            </tr>
                        <?php 
            }
            ?>
                    <?php 
        } else {
            ?>
                        <tr>
                            <td colspan="3">
                                <p><strong><?php 
            esc_html_e( 'No notifications found', 'monitori' );
            ?></strong></p>
                                <a href="<?php 
            echo esc_url( admin_url( 'admin.php?page=monitori-notifications&action=new' ) );
            ?>" class="add-new-h2"><?php 
            esc_html_e( 'Add New', 'monitori' );
            ?></a>
                            </td>
                        </tr>
                    <?php 
        }
        ?>
                </tbody>
            </table>
            <a href="<?php 
        echo esc_url( admin_url( 'admin.php?page=monitori-notifications' ) );
        ?>" class="button button-secondary"><?php 
        esc_html_e( 'View all', 'monitori' );
        ?></a>
        </div>
    <?php 
    }

    public function show_delivery_channels() {
        ?>
        <br />
        <div>
            <h3>Delivery channels</h3>
            <div class="anyf-card-grid">

                <div class="anyf-card">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-slack" viewBox="0 0 16 16">
                        <path d="M3.362 10.11c0 .926-.756 1.681-1.681 1.681S0 11.036 0 10.111.756 8.43 1.68 8.43h1.682zm.846 0c0-.924.756-1.68 1.681-1.68s1.681.756 1.681 1.68v4.21c0 .924-.756 1.68-1.68 1.68a1.685 1.685 0 0 1-1.682-1.68zM5.89 3.362c-.926 0-1.682-.756-1.682-1.681S4.964 0 5.89 0s1.68.756 1.68 1.68v1.682zm0 .846c.924 0 1.68.756 1.68 1.681S6.814 7.57 5.89 7.57H1.68C.757 7.57 0 6.814 0 5.89c0-.926.756-1.682 1.68-1.682zm6.749 1.682c0-.926.755-1.682 1.68-1.682S16 4.964 16 5.889s-.756 1.681-1.68 1.681h-1.681zm-.848 0c0 .924-.755 1.68-1.68 1.68A1.685 1.685 0 0 1 8.43 5.89V1.68C8.43.757 9.186 0 10.11 0c.926 0 1.681.756 1.681 1.68zm-1.681 6.748c.926 0 1.682.756 1.682 1.681S11.036 16 10.11 16s-1.681-.756-1.681-1.68v-1.682h1.68zm0-.847c-.924 0-1.68-.755-1.68-1.68s.756-1.681 1.68-1.681h4.21c.924 0 1.68.756 1.68 1.68 0 .926-.756 1.681-1.68 1.681z" />
                    </svg>
                    <h4><?php 
        esc_html_e( 'Slack', 'monitori' );
        ?></h4>
                    <?php 
        \Monitori\Slack_Setup::get_slack_html( true );
        ?>
                </div>

                <?php 
        ?>

                <div class="anyf-card">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope-fill" viewBox="0 0 16 16">
                        <path d="M.05 3.555A2 2 0 0 1 2 2h12a2 2 0 0 1 1.95 1.555L8 8.414zM0 4.697v7.104l5.803-3.558zM6.761 8.83l-6.57 4.027A2 2 0 0 0 2 14h12a2 2 0 0 0 1.808-1.144l-6.57-4.027L8 9.586zm3.436-.586L16 11.801V4.697z" />
                    </svg>
                    <h4><?php 
        esc_html_e( 'Email', 'monitori' );
        ?></h4>
                    <?php 
        ?>
                        <p><?php 
        esc_html_e( 'Standard email delivery (using WP Mail)', 'monitori' );
        ?></p>
                    <?php 
        ?>
                </div>

            </div>

            <?php 
        ?>
                <br />
                <hr />
                <p><?php 
        esc_html_e( 'You are currently on a free plan', 'monitori' );
        ?></p>
                <a href="<?php 
        echo esc_url( monitori_fs()->get_upgrade_url() );
        ?>" class="button button-primary"><?php 
        esc_html_e( 'Upgrade to Premium', 'monitori' );
        ?></a>
            <?php 
        ?>
        </div>
    <?php 
    }

    public function show_footer() {
        ?>
        <br />
        <hr />
        <div class="anyf-footer">
            <p>
                <?php 
        esc_html_e( 'Need help? Submit a ticket on our ', 'monitori' );
        ?>
                <a href="https://wordpress.org/support/plugin/monitori/">
                    <?php 
        esc_html_e( 'support forum', 'monitori' );
        ?>
                </a>
                <?php 
        esc_html_e( 'or visit our', 'monitori' );
        ?>
                <a href="https://monitori.app/" target="_blank"><?php 
        esc_html_e( 'website', 'monitori' );
        ?></a>
            </p>
        </div>
    <?php 
    }

    public function add_notification_list_page() {
        $page_title = 'Notifications';
        $menu_title = 'Notifications';
        $capability = 'manage_options';
        $menu_slug = 'monitori-notifications';
        $hook_suffix = add_menu_page(
            $page_title,
            $menu_title,
            $capability,
            $menu_slug,
            array($this, 'render_notification_list_page')
        );
        add_action( "load-{$hook_suffix}", array($this, 'screen_options') );
    }

    public function render_notification_list_page() {
        $ajax_nonce = wp_create_nonce( 'monitori_notifications_nonce' );
        ?>
        <div class="wrap">
            <div id="monitori-notifications" data-nonce="<?php 
        echo esc_attr( $ajax_nonce );
        ?>"></div>
        </div>
<?php 
    }

}
