<?php

namespace MonieswitchWP\WooCommerce;


class Connect {

    public $backend_api_url = 'https://koyes.monieswitch.com';
    
    public function __construct()
    {
        if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
               $this->woocommerce_init();
        }
    }
    
    public function woocommerce_init() {
        add_filter( 'woocommerce_payment_gateways', [$this, 'wc_add_to_woocommerce_gateways'], 10, 1);
        add_filter( 'plugin_action_links_' . plugin_basename( MONIESWITCH_WP_SYSTEM_FILE_PATH ), [$this, 'wc_gateway_plugin_links']);
        PaymentButton::get_instance();
        API::get_instance();
        add_filter( 'script_loader_tag', [$this, 'defer_passing_js_loading'], 10 );
    }
    
    public function defer_passing_js_loading($url) {
        if ( strpos( $url, 'https://collect.monieswitch.com/pay.js' ) ) {
            return str_replace( ' src', ' defer src', $url );
        }
        
        return $url;
    }
    
    public function wc_gateway_plugin_links($links) {
        $plugin_links = array(
            '<a href="' . admin_url( 'admin.php?page=wc-settings&tab=checkout&section=monieswitch_woocommerce' ) . '">' . __( 'Configure', 'monieswitch' ) . '</a>'
        );
    
        return array_merge( $plugin_links, $links );
    }
    
    public function wc_add_to_woocommerce_gateways($gateways) {
        $gateways[] = '\MonieswitchWP\WooCommerce\Payment';
        return $gateways;
    }

    public function declare_cart_checkout_blocks_compatibility() {
        if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('cart_checkout_blocks', MONIESWITCH_WP_SYSTEM_FILE_PATH, true);
        }
    }

    public function register_order_approval_payment_method_type()
    {
        if ( ! class_exists( '\Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType' ) ) return;

        require_once plugin_dir_path(MONIESWITCH_WP_SYSTEM_FILE_PATH). '/src/WooCommerce/PaymentBlockType.php';

        add_action(
            'woocommerce_blocks_payment_method_type_registration',
            function( \Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry ) {
                $payment_method_registry->register(new PaymentBlockType);
            }
        );
    }

    /**
     * @return Connect
     */
    public static function get_instance()
    {
        static $instance = null;
        
        if (is_null($instance)) {
            $instance = new self();
        }
        
        return $instance;
    }
}