<?php

namespace MonieswitchWP;

class Init {

    public function __construct()
    {
        add_action( 'admin_notices', array( $this, 'monieswitch_wp_dependencies' ) );
        $this->init();
    }

    public function init() {
        \MonieswitchWP\WooCommerce\Connect::get_instance();
    }

    public function monieswitch_wp_dependencies() {
        if ( ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
            /* translators: %s: URL to install WooCommerce plugin */
            echo '<div class="error"><p>'. sprintf(wp_kses(__('<strong>Monieswitch Warning:</strong> Woocommerce plugin is missing or inactive. For Integration with Woocommerce, kindly download, install and activate <a href="%s">Woocommerce plugin.</a>', 'monieswitch'), array('strong' => array(), 'a' => array('href' => array()))), esc_url(admin_url('/plugin-install.php?s=woocommerce&tab=search&type=term'))). '</p></div>';
        }
    }

    /**
     * @return self
     */
    public static function get_instance()
    {
        static $instance = null;

        if (is_null($instance)) {
            $instance = new self();
        }

        return $instance;
    }
}