<?php

namespace MonieswitchWP\WooCommerce;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class PaymentBlockType extends AbstractPaymentMethodType {

    private $gateway;

    protected $name = 'monieswitch_woocommerce';

    public function initialize() {
        // get payment gateway settings
        $this->settings = get_option( "woocommerce_{$this->name}_settings", array() );
//        $this->gateway = new Payment();
    }

    public function is_active() {
        if(!empty($this->settings[ 'enabled' ]) && 'yes' === $this->settings[ 'enabled' ]) {
            if (!empty($this->settings['public_key'])) {
                return true;
            }

            return false;
        }
        return false;
    }

    public function get_payment_method_script_handles() {
        wp_register_script(
            'monieswitch-woocommerce-blocks-integration',
            plugin_dir_url( MONIESWITCH_WP_SYSTEM_FILE_PATH ) . 'build/index.js',
            array(
                'wc-blocks-registry',
                'wc-settings',
                'wp-element',
                'wp-html-entities',
                'wp-i18n',
            ),
            time(),
            true
        );

        if( function_exists( 'wp_set_script_translations' ) ) {
            wp_set_script_translations( 'monieswitch-woocommerce-blocks-integration');

        }

        return array( 'monieswitch-woocommerce-blocks-integration' );
    }

    public function get_payment_method_data() {
        return array(
            'title'        => $this->get_setting( 'title' ),
            'description'  => $this->get_setting( 'description' ),
            'public_key'  => $this->get_setting( 'public_key' ),
            'secret_key'  => $this->get_setting( 'secret_key' ),
            'customer_phone'  => $this->get_setting( 'customer_phone' ),
            'bearer'  => $this->get_setting( 'bearer' ),
            'subaccount'  => $this->get_setting( 'subaccount' ),
            'payment_page'  => $this->get_setting( 'payment_page' ),
            'channels'  => $this->get_setting( 'channels' ),
        );
    }
}