# Monieswitch WooCommerce Payment Gateway

Monieswitch is a simple and secure payment gateway integration for WooCommerce, enabling seamless transactions with a variety of features. Currently, it supports payment via **bank transfer** and will soon add more options like **credit card payments**. With Monieswitch, merchants can provide customers a flexible and secure way to pay.

## Features
- **Popup payment interface** for secure transactions.
- **Customizable settings** for merchant preferences.
- **Order management** with the option to automatically mark orders as complete.
- **Customizable transaction channels** (currently supports **bank transfer**).
- **Configurable bearer options** for fee management.
- Integration with **WooCommerce** for easy setup and management.
- **Customer Info Submission**: Allows the submission of customer information (phone number) as part of the payment process.
- **Shortcode Support**: Use a customizable shortcode to integrate the Monieswitch payment button anywhere on your site with parameters like amount, currency, channel, bearer, and subaccount.
- **Detailed Logs**: Access detailed logs for troubleshooting by checking the Monieswitch transaction logs under WooCommerce's status page.
- **Bearer Options**: Choose who will pay the transaction fee, either the **merchant account**, the **customer**, or a **subaccount**. This helps manage who absorbs the transaction cost, providing more flexibility for merchants.


## Installation

1. Download the Monieswitch plugin zip file.
2. Go to your **WordPress Dashboard** → **Plugins** → **Add New**.
3. Upload the zip file and install the plugin.
4. After installation, click **Activate**.

## Configuring Monieswitch Payment Gateway

Once the plugin is activated, you can configure the payment settings by following these steps:

1. Go to **WooCommerce** → **Settings** → **Payments**.
2. Find **Monieswitch** in the list of payment methods and click on the **Manage** button.

Alternatively, after activation, you can click Configure directly from the plugin list in the WordPress admin to access the Monieswitch Payment Settings.

### Available Settings

#### 1. **Enable/Disable Monieswitch**
   - **Checkbox** to enable or disable the Monieswitch payment gateway. When disabled, it won't show as an option on the checkout page.

#### 2. **Title**
   - **Default:** "Pay with Monieswitch"
   - The title displayed to customers on the checkout page. You can customize this to fit your store's needs.

#### 3. **Description**
   - A **description field** to provide additional details to your customers about using Monieswitch as a payment option  or any important information about the payment process. This description will appear below the title on the checkout page.

#### 4. **Payment Option**
   - Currently, only **Popup** is available. More payment options will be added in future updates.

#### 5. **Public & Secret Keys**
   - Enter the **public key** and **secret key** provided by Monieswitch. These are **required** to enable transactions and authenticate your store with Monieswitch.

#### 6. **Auto-complete Order**
   - **Checkbox** that, when enabled, automatically sets the order status to **Completed** after the payment is processed, without waiting for a confirmation from the Monieswitch webhook.

#### 7. **Channels**
   - Currently, **Bank Transfer** is the only available channel. More options, such as **Credit Card**, will be added in the future.

#### 8. **Customer Phone Checkbox**
   - When enabled, the customer's **phone number** will be sent along with the payment request to Monieswitch.

#### 9. **Bearer Option**
   - Choose who will be responsible for transaction fees:
     - **Account**: Charges will be deducted from your Monieswitch merchant account.
     - **Customer**: The customer will pay the transaction fees as part of the payment amount.
     - **Subaccount**: Charges will be deducted from a **subaccount** you manage. If you select this option, you must enter the **subaccount email address** in the "Subaccount" field.

#### 10. **Subaccount**
   - If you selected **Subaccount** as the bearer option, provide the **subaccount email address** here.

### Using Monieswitch for payment

Monieswitch can be used in two ways:

1. **Via the Checkout Page**: Customers can choose Monieswitch as a payment option during checkout.
2. **Via Shortcode**: You can use the `[monieswitch]` shortcode on any page to generate a "Pay Now" button with the specified parameters. 

#### Shortcode Example

You can also use the Monieswitch payment gateway through a shortcode on any page to display the Monieswitch payment button with specific parameters.

```
[monieswitch amount="10000"]

[monieswitch amount="10000" currency="USD" channel="BANK" bearer="customer"]

[monieswitch amount="10000" currency="USD" channel="BANK" bearer="subaccount" subaccount="subaccount@example.com"]
```

- **amount**: The amount to be paid. 
- **currency**: The currency for the transaction.  
- **channel**: The payment channel (currently only supports `BANK`).
- **bearer**: Choose the bearer of the transaction fee. This can be:
  - `account`: The merchant's account will bear the transaction fee.
  - `customer`: The customer will bear the transaction fee.
  - `subaccount`: A subaccount will bear the transaction fee. If you choose this, you need to provide the **subaccount email**.
- **subaccount**: (Optional) Enter the subaccount email address if you are using the `subaccount` bearer option.  


### How the Shortcode Works

When the shortcode is used, a **"Pay Now"** button will appear on the page. After clicking the button, a pop-up will appear with the following fields:

- **Title and Amount**: Displayed as per your configuration in the Monieswitch settings.
  
- **Email Address and Phone Number**: Customer input fields where the customer enters their email and phone number for payment processing.

After submitting the form, the customer will see a confirmation screen with the payment details and an option to confirm the payment. Once Monieswitch processes the payment, you will be notified, and the order status will be updated accordingly.


### Troubleshooting

If you encounter any errors during the payment process:

1. Go to **WooCommerce** → **Status** → **Logs**.
2. Look for the log file titled `monieswitch_woocommerce`.
3. Click on the log to view detailed error information.

## External Services

This plugin connects to Monieswitch's payment processing API to facilitate secure payment transactions.

### Monieswitch Payment API

**What the service is and what it is used for:**
The plugin connects to Monieswitch's payment processing service to initialize and verify payment transactions. This service is necessary for processing payments through the Monieswitch gateway.

**What data is sent and when:**
- Customer information (email and optionally phone number) is sent when initializing a payment.
- Transaction details including amount, currency, and reference are sent when processing a payment.
- The plugin communicates with Monieswitch servers (https://collect.monieswitch.com and https://nini.monieswitch.com) to load payment scripts and process transactions.

**Service Terms and Privacy:**
- Terms of Service: [https://monieswitch.com/terms](https://monieswitch.com/terms)
- Privacy Policy: [https://monieswitch.com/policy](https://monieswitch.com/policy)
