<?php

/*
Plugin Name: Monieswitch
Plugin URI:  https://docs.monieswitch.com/sdks/plugins/woocommerce
Description: Monieswitch Payment Gateway for WordPress and WooCommerce, enabling seamless transactions with bank transfers.
Version: 1.0.2
Author: Monieswitch
Author URI: https://monieswitch.com
License: GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: monieswitch
Domain Path: /languages
Requires at least: 5.0
Requires PHP: 7.2
WC requires at least: 4.0
WC tested up to: 8.0
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

require __DIR__ . '/vendor/autoload.php';

define('MONIESWITCH_WP_SYSTEM_FILE_PATH', __FILE__);
define('MONIESWITCH_WP_SYSTEM_DIRECTORY', __DIR__);
define('MONIESWITCH_WP_VERSION_NUMBER', '1.0.2');

add_action( 'plugins_loaded', 'monieswitch_gateway_init', 11);

function monieswitch_gateway_init() {
    \MonieswitchWP\Init::get_instance();
}

function monieswitch_wp_declare_cart_checkout_blocks_compatibility() {
    if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('cart_checkout_blocks', __FILE__, true);
        // Declare compatibility with HPOS (High-Performance Order Storage)
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
}

add_action('before_woocommerce_init', 'monieswitch_wp_declare_cart_checkout_blocks_compatibility');

add_action( 'woocommerce_blocks_loaded', 'monieswitch_wp_oawoo_register_order_approval_payment_method_type' );

function monieswitch_wp_oawoo_register_order_approval_payment_method_type() {
    if ( ! class_exists( 'Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType' ) ) {
        return;
    }

    add_action(
        'woocommerce_blocks_payment_method_type_registration',
        function( Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry ) {
            $payment_method_registry->register( new \MonieswitchWP\WooCommerce\PaymentBlockType );
        }
    );
}