(function ($) {
    "use strict";

    let monieswitch_submit = false;

    let monieswitch = {};

    let monieswitch_random_number = 0;

    monieswitch.monieswitchFormHandler = function() {
        //hide the form
        $('#monieswitch-form').hide();

        if ( monieswitch_submit ) {
            monieswitch_submit = false;
            return true;
        }

        let $form = $( '#monieswitch_woocommerce_form form#payment-form, #monieswitch_woocommerce_form form#order_review' );

        let monieswitch_callback = function (response) {

            $form.append( '<input type="hidden" class="monieswitch_reference" name="monieswitch_reference" value="' + response + '"/>' );

            $form.submit();

            $( 'body' ).block( {
                message: null,
                overlayCSS: {
                    background: '#fff',
                    opacity: 0.6
                },
                css: {
                    cursor: "wait"
                }
            } );
        }

        const email = wc_monieswitch_params.email;
        const amount = parseFloat(wc_monieswitch_params.amount);
        const publicKey = wc_monieswitch_params.publicKey;
        const currency = wc_monieswitch_params.currency;
        const reference = wc_monieswitch_params.reference;
        const channels = wc_monieswitch_params.channels;
        const bearer = wc_monieswitch_params.bearer;
        const subaccountId = wc_monieswitch_params.subaccountId;
        const secret_key = wc_monieswitch_params.secret_key;
        const payment_page = wc_monieswitch_params.payment_page;
        monieswitch_random_number = Math.random().toString(36).substring(2);

        let monieswitchData = {
            onClose: function () {
                $( '#monieswitch-form').show();
                $( this.el).unblock();
            },
            onError: function () {
                $( '#monieswitch-form').show();
                $( this.el).unblock();
            },
            onSuccess: monieswitch_callback
        }

        if(payment_page === 'external' || payment_page === 'server') {
            const checkoutCode = wc_monieswitch_params.data.checkout.code;
            let payment_option = '';
            const monieswitchCheckoutData = {
                checkoutCode: checkoutCode,
                onClose: function () {
                    $( '#monieswitch-form').show();
                    $( this.el).unblock();
                },
                onError: function () {
                    $( '#monieswitch-form').show();
                    $( this.el).unblock();
                },
                onSuccess: monieswitch_callback
            }
            monieswitchData.checkoutCode = checkoutCode;

            if(payment_page === 'external') {
                if(typeof wc_monieswitch_params.data.checkout.link !== 'undefined') {
                    payment_option = wc_monieswitch_params.data;
                    payment_option = wc_monieswitch_params.data.checkout.link;
                    window.location.href = payment_option;
                    return false;
                }
            } else {
                PayWithMonieswitch.continueCheckout( monieswitchCheckoutData );
            }

        } else {
            monieswitchData.email = email;
            monieswitchData.amount = amount;
            monieswitchData.publicKey = publicKey;
            monieswitchData.currency = currency;
            monieswitchData.reference = reference;
            monieswitchData.channels = channels;
            monieswitchData.bearer = bearer;
            monieswitchData.subaccountId = subaccountId;

            PayWithMonieswitch.checkout( monieswitchData );
        }
    }

    monieswitch.checkValidParameters = function() {
        $('#monieswitch-form button#monieswitch-payment-button').hide();
        if(typeof wc_monieswitch_params !== 'undefined') {
            $('#monieswitch-form p.monieswitch_error_message').hide();
            $('#monieswitch-form button#monieswitch-payment-button').show();
        } else {
            $('#monieswitch-form p.monieswitch_error_message').show();
        }
    }

    monieswitch.openMonieswitchFormDialog = function () {
        let pop_id = $(this).data('custom-popup');

        let find_popup_el = $(this).parents('body').find('#' + pop_id);
        find_popup_el.show();
    }

    monieswitch.closeMonieswitchFormDialog = function () {
        let find_popup_el = $(this).parents('.monieswitch_custom_payment_container').hide();
        find_popup_el.hide();
    }

    monieswitch.submitPaymentFormHandler = function (e) {
        e.preventDefault();
        e.stopPropagation();

        $(this).find('input[type=submit]').attr('disabled', true);
        $(this).find('input[type=submit]').val('Please wait...');

        const form = new FormData(this);
        const email = form.get('monieswitch-email');
        const amount = parseFloat(form.get('monieswitch-amount'));
        const phone = form.get('monieswitch-phone-number');
        const nonce = form.get('monieswitch-nonce');
        const button_id = form.get('monieswitch-button-id');
        const reference = $(this).data('form-reference');

        let error_el = $(this).parents('.monieswitch-monieswitch-container').find('.error');
        let success_el = $(this).parents('.monieswitch-monieswitch-container').find('.success');

        const _this = this;

        error_el.hide();
        success_el.hide();
        error_el.html('');
        success_el.html('');

        let error_count = 0;
        let error_message = '';

        let email_reg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
        let phone_reg = /^\d{11}$/;

        if(email === '') {
            error_count += 1;
            error_message += '<p>Please enter your email</p>'
        }

        if(!email_reg.test(email)) {
            error_count += 1;
            error_message += '<p>Please enter a valid email</p>'
        }

        if(amount === 0) {
            error_count += 1;
            error_message += '<p>No amount was specified</p>';
        }

        if(button_id === '') {
            error_count += 1;
            error_message += '<p>There is something wrong, please refresh your page and try again</p>'
        }

        if(phone.length > 0 && !phone_reg.test(phone)) {
            error_count += 1;
            error_message += '<p>Enter a valid phone number</p>'
        }

        if(error_count > 0) {
            error_el.html(error_message);
            error_el.fadeIn(350);
            $(this).find('input[type=submit]').removeAttr('disabled');
            $(this).find('input[type=submit]').val('Proceed');
            return;
        }

        monieswitch_random_number = Math.random().toString(36).substring(2);


        let data = {
            email,
            amount,
            phone,
            nonce,
            button_id,
            reference,
            'action': 'monieswitch_custom_payment_handler'
        }

        let successHandler = (response) => {
            if(response.status === false) {
                error_el.html(response.message);
                error_el.fadeIn(350);
                $( this.el).unblock();
                return;
            }

            const email = response.data.email;
            const amount = parseFloat(response.data.amount);
            const publicKey = wc_monieswitch_params.publicKey;
            const currency = wc_monieswitch_params.currency;
            const reference = response.data.reference;

            let monieswitchData = {
                email,
                amount,
                publicKey,
                reference,
                currency,
                onClose: function () {
                    $(_this).find('input[type=submit]').removeAttr('disabled');
                    $(_this).find('input[type=submit]').val('Proceed');
                    error_el.html('Payment dailog closed');
                    error_el.fadeIn(300);
                    $( this.el).unblock();
                },
                onError: function () {
                    $(_this).find('input[type=submit]').removeAttr('disabled');
                    $(_this).find('input[type=submit]').val('Proceed');
                    error_el.html('Payment dailog closed');
                    error_el.fadeIn(300);
                    $( this.el).unblock();
                },
                onSuccess: (response) => {
                    success_el.html('<p>Bank Payment with reference number - ' + response + ' was successful. <a href="javascript:void(0)" class="monieswitch-close-dialog" onclick="$(this).parents(\'.monieswitch_custom_payment_container\').hide();">Close dialog</a></p>');
                    $(_this).fadeOut(350);
                    _this.reset();
                    success_el.fadeIn(350);
                },
            }

            if(phone.length > 0) {
                monieswitchData.phoneNumber = phone;
            }

            if(wc_monieswitch_params.subaccountId) {
                monieswitchData.subaccountId = wc_monieswitch_params.subaccountId;
            }

            if(wc_monieswitch_params.bearer) {
                monieswitchData.bearer = wc_monieswitch_params.bearer;
            }

            if(wc_monieswitch_params.channels) {
                monieswitchData.channels = wc_monieswitch_params.channels;
            }

            console.log(monieswitchData);

            PayWithMonieswitch.checkout( monieswitchData );

            return false;
        }

        let monieswitchData = {
            type: 'POST',
            dataType: 'json',
            url: wc_monieswitch_params.ajax_url,
            data,
            success: successHandler,
            error: (jqXHR, textStatus, errorThrown) => {
                error_el.innerHTML = errorThrown;
                error_el.fadeIn(350);
            }
        }

        $.ajax(monieswitchData);
    }

    monieswitch.stopCloseFormDialog = (e) => {
        e.stopPropagation();
    }

    monieswitch.forceCloseFormDialog = (e) => {
        $('.monieswitch_custom_payment_container').fadeOut(350);
        e.preventDefault();
    }


    monieswitch.init = function () {
        monieswitch.checkValidParameters();
        $(document).on('click', '#monieswitch-payment-button', monieswitch.monieswitchFormHandler);
        $(document).on('click', 'button.monieswitch-custom-payment-button', monieswitch.openMonieswitchFormDialog);
        $(document).on('click', '.monieswitch-close-button, .monieswitch-close-dialog', monieswitch.closeMonieswitchFormDialog);
        $(document).on('submit', 'form.monieswitch-payment-form', monieswitch.submitPaymentFormHandler);
        $(document).on('click', 'section .monieswitch-monieswitch-container', monieswitch.stopCloseFormDialog);
        $(document).on('click', 'section.monieswitch_custom_payment_container', monieswitch.forceCloseFormDialog);
    }

    $(window).on('load', () => {
        monieswitch.init();
    });


})(jQuery);