<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

$videoID = "mlibOffVideo_".rand(1111,8888);

?>
<style>
    #<?php echo $videoID; ?>.mlibOffVideo {
        display: block;
        position: relative;
        text-align: center;
        width: <?php echo $width; ?>;
        height: auto;
        margin: auto;
        border: 1px #000000 solid;
    }
    #<?php echo $videoID; ?>.mlibOffVideo .mlibOffVideoLoading  {
        display: none;
        position: absolute;
        bottom: 26px; left: 0px;
        text-align: center;
        width: 100%;
        height: auto;
        margin: auto;
        padding: 5px;
        color: #ffffff;
        background-color: #333333;
        font-size: 11px;
    }
    #<?php echo $videoID; ?>.mlibOffVideo video {
        margin: 0px;
        padding: 0px;
        width: 100%;
        height:<?php echo $height; ?>;
    }
    #<?php echo $videoID; ?>.mlibOffVideo .mlibOffVideoControls {
        margin: 0px;
        padding: 0px;
        height: 25px;
        text-align: center;
        display: flex;
        align-items: center;
        justify-content: space-around;
        border-top: 1px #000000 solid;
    }
    #<?php echo $videoID; ?>.mlibOffVideo input[type=button] {
        width: 15%;
        height: 15px;
        padding: 2px;
        font-size: 11px;
        margin-right: 2px;
    }
    #<?php echo $videoID; ?>.mlibOffVideo input[type=range] {
        width: 75%;
        height: 15px;
        padding: 0px;
        margin: 0px;
    }
</style>
<div class="mlibOffVideo" id="<?php echo $videoID; ?>">
    <div class="mlibOffVideoLoading">
        <?php _e("Loading...", "mlibOff"); ?>
    </div>
    <video width="800" height="600" style=""<?php if (isset($preview) && $preview != '') echo ' poster="'.$preview.'"'; ?>>
        <source src="<?php echo $url; ?>" type="video/mp4" />
        <?php _e("Your browser does not support the video tag.", "mlibOff"); ?>
    </video>
    <div class="mlibOffVideoControls">
        <input type="button" name="<?php echo $videoID; ?>_play" value="<?php _e("Play", "mlibOff"); ?>" />
        <input type="range" name="<?php echo $videoID; ?>_range" value="0" />
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() {
        
       var video = jQuery("#<?php echo $videoID; ?> video").get(0);
       video.volume = 1;
       
       jQuery("#<?php echo $videoID; ?>.mlibOffVideo video").on("click", function() {
            jQuery("#<?php echo $videoID; ?>.mlibOffVideo .mlibOffVideoControls input[type=button]").trigger("click");
       });
       jQuery("#<?php echo $videoID; ?>.mlibOffVideo video").on("dblclick", function() {
              if (video.requestFullscreen) {
                video.requestFullscreen();
              } else if (video.mozRequestFullScreen) {
                video.mozRequestFullScreen(); // Firefox
              } else if (video.webkitRequestFullscreen) {
                video.webkitRequestFullscreen(); // Chrome and Safari
              }
       });
       
       jQuery("#<?php echo $videoID; ?>.mlibOffVideo .mlibOffVideoControls input[type=button]").on("click", function() {
            if (video.paused == true)  {
                video.play();
                jQuery("#<?php echo $videoID; ?>.mlibOffVideo .mlibOffVideoControls input[type=button]").val('<?php _e("Pause", "mlibOff"); ?>');
                jQuery("#<?php echo $videoID; ?>.mlibOffVideo .mlibOffVideoLoading").css('display','block');
            } else {
                video.pause();
                jQuery("#<?php echo $videoID; ?>.mlibOffVideo .mlibOffVideoControls input[type=button]").val('<?php _e("Play", "mlibOff"); ?>');
            }
       });
       
       jQuery("#<?php echo $videoID; ?>.mlibOffVideo .mlibOffVideoControls input[type=range]").on("change", function() {
            var time = video.duration * (jQuery(this).val() / 100);
            video.currentTime = time;
       }).on("mouseup", function() {
            video.play();
            jQuery("#<?php echo $videoID; ?>.mlibOffVideo .mlibOffVideoControls input[type=button]").val('<?php _e("Pause", "mlibOff"); ?>');
            jQuery("#<?php echo $videoID; ?>.mlibOffVideo .mlibOffVideoLoading").css('display','block');
       }).on("mousedown", function() {
            video.pause();
            jQuery("#<?php echo $videoID; ?>.mlibOffVideo .mlibOffVideoControls input[type=button]").val('<?php _e("Play", "mlibOff"); ?>');
       });
       video.addEventListener("timeupdate", function() {
            var value = (100 / video.duration) * video.currentTime;
            jQuery("#<?php echo $videoID; ?>.mlibOffVideo .mlibOffVideoControls input[type=range]").val(value);
            jQuery("#<?php echo $videoID; ?>.mlibOffVideo .mlibOffVideoLoading").css('display','none');
          });
       video.addEventListener("waiting", function() {
            jQuery("#<?php echo $videoID; ?>.mlibOffVideo .mlibOffVideoLoading").css('display','block');
          });
    });
    
</script>