<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// For Monelib purposes
$mlibOff_gateway_pfm = '5';


// Start session if not already done (called when needed)
function mlibOff_myStartSession() {
	if(!session_id()) {
        session_start();
    }
}

// Just changes what we have to change in the XML data values...
function __mlibOff_xmlencrypt($str) {
    $str = str_replace('&', '&amp;', $str);
    $str = str_replace('<', '&lt;', $str);
    $str = str_replace('>', '&gt;', $str);
    $str = str_replace("'", '&apos;', $str);
    $str = str_replace('"', '&quot;', $str);
    return $str;
}

// Load the zones in a static way as we don't need to do it each time
// We can force it, needed in the admin
function mlibOff_getResults_static($force = false) {
	static $results = null;
	
	if ($results === null || $force) {
		global $wpdb;
		$table_name = $wpdb->prefix . 'mliboff_zones';
		$results = $wpdb->get_results("SELECT * FROM ".$table_name." ORDER BY name ASC", "ARRAY_A");
	}
	
	return $results;
}

// Execute Monelib gateway request as described in our official docs
function mlibOff_execute_command($cmd, $options) {
    global $mlibOff_gateway_pfm;
    
    $xml = '<?xml version="1.0" encoding="utf-8"?>'."\n";
    $xml.= '<gateway>'."\n";
    $xml.= '    <'.$cmd.'>'."\n";
    $xml.= '        <pfm>'.__mlibOff_xmlencrypt($mlibOff_gateway_pfm).'</pfm>'."\n";
    foreach($options as $k=>$v) {
        $xml.= '        <'.$k.'>'.__mlibOff_xmlencrypt($v).'</'.$k.'>'."\n";
    }
    $xml.= '    </'.$cmd.'>'."\n";
    $xml.= '</gateway>'."\n";
    
    $url = 'http://gw.monelib.com/';
    $fields = array('ext_xml'=>$xml);
    
    // use of wp_remote_post instead of curl...
    global $wp_version;
    $args = array(
        'method'      => 'POST',
        'timeout'     => 10,
        'redirection' => 5,
        'httpversion' => '1.0',
        'user-agent'  => 'WordPress/' . $wp_version . '; ' . home_url(),
        'blocking'    => true,
        'headers'     => array(),
        'cookies'     => array(),
        'body'        => $fields,
        'compress'    => false,
        'decompress'  => true,
        'sslverify'   => false,
        'stream'      => false,
        'filename'    => null
    ); 
    $response = wp_remote_post( $url, $args );
    if( is_array($response) ) {
      $_result = $response['body'];
    } else $_result = '';
    
    // There's a problem !!!
    if ($_result === '') {
        throw new Exception("Error Request", 99);
    }
    
    // So simple with that native function 
    $result = simplexml_load_string($_result);
    
    if (!isset($result->poslist->pos)) {
        throw new Exception("Error Request", 98);
    }
    
    return $result;
}

// Get the Point of Sale !
function mlibOff_getPos($username, $password) {
    $datas = array();
    $datas['login'] = $username;
    $datas['password'] = $password;
    
    
    $posLists = array();
    
    try {
        $res = mlibOff_execute_command('getxposlist', $datas);
        
        $paytypes = mlibOff_get_paytype();
        foreach($res->poslist->pos as $k=>$pos) {
            if (!isset($paytypes[''.$pos->paytype])) continue;
            $posLists[''.$pos->id] = $pos;
        }
        
    } catch (Exception $e) {
        $posLists['0'] = __('Error fetching poslist','mlibOff');
    }
    
    return $posLists;
}

// List all the type of Point of Sale that we accept.
function mlibOff_get_paytype () {
    
    $paytypes = array();
    $paytypes['1'] = __('MicroPayment', 'mlibOff');
    $paytypes['2'] = __('MultiShot', 'mlibOff');
    $paytypes['3'] = __('EzShot', 'mlibOff');
    
    return $paytypes;
}


class mlibOff_Encryption {
	public $skey 	= "SeedToBeChandsfsdfged By Option"; // you can change it
	
    public  function safe_b64encode($string) {
	
        $data = base64_encode($string);
        $data = str_replace(array('+','/','='),array('-','_',''),$data);
        return $data;
    }
 
	public function safe_b64decode($string) {
        $data = str_replace(array('-','_'),array('+','/'),$string);
        $mod4 = strlen($data) % 4;
        if ($mod4) {
            $data .= substr('====', $mod4);
        }
        return base64_decode($data);
    }
	
    public  function encode($value){ 
		
	    if(!$value){return false;}
        $text = $value;
        $iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
        $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
        $crypttext = mcrypt_encrypt(MCRYPT_RIJNDAEL_256, md5($this->skey), $text, MCRYPT_MODE_ECB, $iv);
        return trim($this->safe_b64encode($crypttext)); 
    }
    
    public function decode($value){
		
        if(!$value){return false;}
        $crypttext = $this->safe_b64decode($value); 
        $iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
        $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
        $decrypttext = mcrypt_decrypt(MCRYPT_RIJNDAEL_256, md5($this->skey), $crypttext, MCRYPT_MODE_ECB, $iv);
        return trim($decrypttext);
    }
}

/**
 * Outputs the specified file to the browser.
 *
 * @param string $filePath the path to the file to output
 * @param string $fileName the name of the file
 * @param string $mimeType the type of file
 */
function mlibOff_outputFile($filePath, $fileName, $mimeType = '') {
    // Setup
    $mimeTypes = array(
        'pdf' => 'application/pdf',
        'txt' => 'text/plain',
        'html' => 'text/html',
        'exe' => 'application/octet-stream',
        'zip' => 'application/zip',
        'doc' => 'application/msword',
        'xls' => 'application/vnd.ms-excel',
        'ppt' => 'application/vnd.ms-powerpoint',
        'gif' => 'image/gif',
        'png' => 'image/png',
        'jpeg' => 'image/jpg',
        'jpg' => 'image/jpg',
        'mp4' => 'video/mp4',
        'ogv' => 'video/ogg',
        'webm' => 'video/webm',
        'php' => 'text/plain'
    );

    $fileSize = filesize($filePath);
    $fileName = rawurldecode($fileName);
    $fileExt = '';

    // Determine MIME Type
    if($mimeType == '') {
        $fileExt = strtolower(substr(strrchr($filePath, '.'), 1));

        if(array_key_exists($fileExt, $mimeTypes)) {
            $mimeType = $mimeTypes[$fileExt];
        }
        else {
            $mimeType = 'application/force-download';
        }
    }

    // Disable Output Buffering
    @ob_end_clean();
	

    // IE Required
    if(ini_get('zlib.output_compression')) {
        ini_set('zlib.output_compression', 'Off');
    }
	
	header('Accept-Ranges: bytes');
	header('Keep-Alive: Off'); 

    // Multipart-Download and Download Resuming Support
    if(isset($_SERVER['HTTP_RANGE'])) {
        list($a, $range) = explode('=', $_SERVER['HTTP_RANGE'], 2);
        list($range) = explode(',', $range, 2);
        list($range, $rangeEnd) = explode('-', $range);

        $range = intval($range);

        if(!$rangeEnd) {
            $rangeEnd = $fileSize-1;
        }
        else {
            $rangeEnd = intval($rangeEnd);
        }
		

        $newLength = 1 + $rangeEnd - $range;
        // Send Headers
		
	    header('HTTP/1.1 206 Partial Content');
        header('Content-Range: bytes '.$range.'-'.$rangeEnd.'/'.$fileSize);
		header('Content-Length: ' . $newLength);
    }
    else {
        $newLength = $fileSize;
	    header('HTTP/1.1 200 OK');
        header('Content-Length: ' . $newLength);
		header('Content-Disposition: attachment; filename="' . $fileName . '"');
		header('Content-Transfer-Encoding: binary');
    }
	
	header('Content-Type: ' . $mimeType);

    // Output File
    $chunkSize = (8*1024);
    $bytesSend = 0;

    if($file = fopen($filePath, 'rb')) {
		
        if(isset($_SERVER['HTTP_RANGE'])) {
            fseek($file, $range);
        }
		
		while(!feof($file) && !connection_aborted() && $bytesSend < $newLength) {
			if ($chunkSize + $bytesSend > $newLength) {
				$_chunkSize = $newLength - $bytesSend;
			} else $_chunkSize = $chunkSize;
			$buffer = fread($file, $_chunkSize);
			echo $buffer;
			flush();
			$bytesSend += strlen($buffer);
		}

		fclose($file);
    }
}

?>