<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Update the database... if needed.
function mlibOff_update_db_check() {
    global $wpdb;
    global $mlibOff_dbversion;
    
    // The installed version is set in a wordpress option
    $installed_ver = (double) get_option( "mlibOff_dbversion" );
    if ( $installed_ver != $mlibOff_dbversion ) {
            
            $table_name = $wpdb->prefix . 'mliboff_zones';
    
            $sql = "CREATE TABLE $table_name (
                    id mediumint(9) NOT NULL AUTO_INCREMENT,
                    dte TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
                    name text DEFAULT '' NOT NULL,
                    pos_name text DEFAULT '' NOT NULL,
                    pos_id int DEFAULT 0 NOT NULL,
                    pos_zos_id int DEFAULT 0 NOT NULL,
                    pos_paytype int DEFAULT 0 NOT NULL
            );";
    
            require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
            dbDelta( $sql );
            
            // Le Primary Key doit être viré !!
            if ($installed_ver > 0 && $installed_ver < 1.6) {
                $query = "ALTER TABLE `".$table_name."` DROP PRIMARY KEY";
                $wpdb->query($query);
            }
            // La clé sur l'index doit être créée !!
            if ($installed_ver < 1.6) {
                $query = "ALTER TABLE `".$table_name."` ADD INDEX (`id`)";
                $wpdb->query($query);
            }
            
            update_option( "mlibOff_dbversion", $mlibOff_dbversion );
    }
}
add_action( 'plugins_loaded', 'mlibOff_update_db_check' );

?>