<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


function mlibOff_add_stylesheet_to_admin() {
	wp_enqueue_style( 'mliboff-admin-style', plugins_url('mlibOff_admin_style.css', __FILE__) );
}
add_action( 'admin_enqueue_scripts', 'mlibOff_add_stylesheet_to_admin' );

function mlibOff_add_monelib_column($columns) {
	$newColumns = array();
	
	foreach ($columns as $k=>$v) {
		$newColumns[$k] = $v;
		if ($k == "cb") {
			$newColumns['monelib'] = "<span>".__('Monelib')."</span>";
		}
	}
	
	return $newColumns;
}
add_filter('manage_posts_columns' , 'mlibOff_add_monelib_column');
add_filter('manage_pages_columns' , 'mlibOff_add_monelib_column');


function mlibOff_add_monelib_column_data($column, $post_id) {
	
	if ($column == 'monelib') {
		$post = get_post($post_id);
		// Protected with the shortcode ?
		if (has_shortcode($post->post_content,'monelib')) {
			echo "<span>".__('M', 'mlibOff')."</span>";
		} else {
		}
	}
	
	return;
}
add_filter('manage_posts_custom_column' , 'mlibOff_add_monelib_column_data', 10, 2);
add_filter('manage_pages_custom_column' , 'mlibOff_add_monelib_column_data', 10, 2);


function mlibOff_setup_menu() {
	add_menu_page( __('Monelib Setup Page','mlibOff'), 'Monelib', 'manage_options', 'mlibOff-setup', 'mlibOff_setup_hook' );
}
add_action('admin_menu', 'mlibOff_setup_menu');

// The setup page !!
function mlibOff_setup_hook() {
	?>

<h1><?php _e('Monelib Setup Page','mlibOff'); ?></h1>
<br />
<?php

	// Check the Login/Password provided (if any already provided)
	$mlibOff_opt_login = get_option( "mlibOff_gwlogin" );
	$mlibOff_opt_passw = get_option( "mlibOff_gwpassw" );
	$mlibOff_force_lang = get_option( "mlibOff_force_lang" );
	
	if ($mlibOff_opt_login != '' && $mlibOff_opt_passw != '') { 
		$AllPos = mlibOff_getPos($mlibOff_opt_login, $mlibOff_opt_passw);
		
		if (isset($AllPos['0'])) {
			$mlibOff_errLogin = true;
		} else {
			$mlibOff_errLogin = false;
		}
	} else $mlibOff_errLogin = true;
	
	// Show the alert in a javascript box (lazyyyy but, hey, that does the job !)
	if (isset($_SESSION['mlibOff_admin_err'])) {
		?>
		<script type="text/javascript">
			alert("<?php echo $_SESSION['mlibOff_admin_err']; ?>");
		</script>
		<?php
		unset($_SESSION['mlibOff_admin_err']);
	}
?>

<h2><?php _e('Basic Configuration','mlibOff'); ?></h2>
<section class="mlibOff">
	<strong><?php _e('Please enter your Monelib username and your gateway password','mlibOff'); ?> :</strong><br /><br />
	<form method="post" type="multipart/form-data" action="?page=mlibOff-setup">
		<input type="hidden" name="frmType" value="basic" />
		<label for="frmLogin"><?php _e('Login','mlibOff'); ?> :</label>
		<input type="text" name="frmLogin" id="frmLogin" value="<?php echo $mlibOff_opt_login; ?>" style="width: 250px;" /><br />
		<label for="frmPassw"><?php _e('Gateway password','mlibOff'); ?> :</label>
		<input type="text" name="frmPassw" id="frmPassw" value="<?php echo $mlibOff_opt_passw; ?>" style="width: 250px;" /><br /><br />
		<label for="frmForceLang"><?php _e('Language in front','mlibOff'); ?> :</label>
		<select name="frmForceLang" id="frmForceLang" style="width: 250px;">
			<option value="auto"><?php _e('Automatic','mlibOff'); ?></option>
			<option value="original"<?php if ($mlibOff_force_lang == 'original') echo "selected='selected'"; ?>><?php _e('Original (en_EN)','mlibOff'); ?></option>
			<?php
			if (is_dir(dirname( __FILE__ ).'/lang/')) {
				$d = dir(dirname( __FILE__ ).'/lang/');
				while (false !== ($entry = $d->read())) {
					if (preg_match("/mlibOff-(.*)\\.mo/", $entry, $regs)) {
						?>
						<option value="<?php echo $regs[1]; ?>"<?php if ($mlibOff_force_lang == $regs[1]) echo "selected='selected'"; ?>><?php echo $regs[1]; ?></option>
						<?php
					}
				 }
				 $d->close();
			}
			
			?>
		</select><br /><br />
		<input type="submit" value="<?php _e('Save the basic configuration','mlibOff'); ?>" />
	</form><br />
	<span class="legend"><?php _e('The gateway password is located in your Monelib account, in the submenu "Gateway Password" under "Advanced" menu.','mlibOff'); ?></span>
</section>

<?php

	$mlibOff_opt_folder = get_option( "mlibOff_folder" );
	$mlibOff_opt_encrypt = get_option( "mlibOff_seed" );
	if ($mlibOff_opt_encrypt == '') {
		$mlibOff_opt_encrypt = substr(md5(rand(11111111,88888888)),0,10);
		update_option( "mlibOff_seed", $mlibOff_opt_encrypt);
	}

?>
<h2><?php _e('Protected content','mlibOff'); ?></h2>
<section class="mlibOff">
	<strong><?php _e('Please enter the folder where the protected content will be stored and the encrypt seed.','mlibOff'); ?> :</strong><br /><br />
	<form method="post" type="multipart/form-data" action="?page=mlibOff-setup">
		<input type="hidden" name="frmType" value="protectedContent" />
		<label for="frmDir"><?php _e('Folder','mlibOff'); ?> :</label>
		<input type="text" name="frmDir" id="frmDir" value="<?php echo $mlibOff_opt_folder; ?>" placeholder="<?php _e('Default is the wp-content folder','mlibOff'); ?>" style="width: 250px;" /><br />
		<label for="frmEncrypt"><?php _e('Encrypt seed','mlibOff'); ?> :</label>
		<input type="text" name="frmEncrypt" id="frmEncrypt" value="<?php echo $mlibOff_opt_encrypt; ?>" placeholder="<?php _e('__mySecretSeed__','mlibOff'); ?>" style="width: 250px;" /><br /><br />
		<input type="submit" value="<?php _e('Save the configuration for the protected content','mlibOff'); ?>" />
	</form><br />
	<span class="legend">
		<?php echo sprintf(__('The folder can be absolute (example "/home/prOtect3d") or relative to "%s" (example "hIdd3nFil3s/").','mlibOff'), ABSPATH."wp-content/"); ?><br />
		<?php _e('The Encrypt seed will always remain secret and is used to encrypt the content filenames.','mlibOff'); ?></span>
</section>



<h2><?php _e('Protected zones','mlibOff'); ?></h2>

<?php

// We've got a problem with provided Login/Password !
if ($mlibOff_errLogin) {
	
	?>
	
<section class="mlibOff">
	<strong><?php _e('Please enter a valid gateway login/password before configuring the protected zones.','mlibOff'); ?></strong>
</section>
	<?php
	
	return;
}

// Here we force BECAUSE we maybe made a change while loading the page
$results = mlibOff_getResults_static(true);

$paytypes = mlibOff_get_paytype();

?>

<section class="mlibOff">
	<table>
		<thead>
		<tr>
			<th>ID</th>
			<th><?php _e('Name','mlibOff'); ?></th>
			<th style="width: 100px;"><?php _e('Pos ID','mlibOff'); ?></th>
			<th><?php _e('Pos name','mlibOff'); ?></th>
			<th>&nbsp;</th>
		</tr>
		<tr>
<?php
  global $mlibOff_debug;
  if ($mlibOff_debug) error_log(print_r($_REQUEST, true));
  if (isset($_REQUEST['frmType']) && $_REQUEST['frmType'] == 'modifyZone') {
	$id = (int)$_REQUEST['id'];
	if ($id <= 0) exit();
	foreach ($results as $result) {
		if ($result['id'] == $id) break;
	}
	
	?>
		<form method="post" type="multipart/form-data" action="?page=mlibOff-setup">
			<input type="hidden" name="frmType" value="updateZone" />
			<input type="hidden" name="frmID" value="<?php echo $result['id']; ?>" />
			<th>--</th>
			<th><input type="text" name="frmName" id="frmName" value="<?php echo $result['name']; ?>" /></th>
			<th>--</th>
			<th><select name="frmPosID" id="frmPosID">
				<option value="0"><?php _e('Please select a Monelib POS','mlibOff'); ?></option>
				<option value="0">------------</option>
				<?php
				foreach($AllPos as $pos) {
					?>
					<option value="<?php echo $pos->id; ?>"<?php if ($pos->id == $result['pos_id']) echo " selected=selected"; ?>>(<?php echo $paytypes[''.$pos->paytype]; ?>) <?php echo $pos->name; ?></option>
					<?php
				}
				?>
			</select></th>
			<th><input type="submit" value="<?php _e('Save','mlibOff'); ?>" /></th>
		</form>
<?php } else { ?>
		<form method="post" type="multipart/form-data" action="?page=mlibOff-setup">
			<input type="hidden" name="frmType" value="addZone" />
			<th>--</th>
			<th><input type="text" name="frmName" id="frmName" value="" /></th>
			<th>--</th>
			<th><select name="frmPosID" id="frmPosID">
				<option value="0"><?php _e('Please select a Monelib POS','mlibOff'); ?></option>
				<option value="0">------------</option>
				<?php
				foreach($AllPos as $pos) {
					?>
					<option value="<?php echo $pos->id; ?>">(<?php echo $paytypes[''.$pos->paytype]; ?>) <?php echo $pos->name; ?></option>
					<?php
				}
				?>
			</select></th>
			<th><input type="submit" value="<?php _e('Save this new zone','mlibOff'); ?>" /></th>
		</form>
<?php } ?>
		</tr>
		</thead>
		<tbody>
<?php
if (count($results) <= 0) {
	?>
		<tr>
			<td class="empty" colspan=5><?php _e('No protected zone yet','mlibOff') ?></td>
		</tr>
	<?php
} else {
	
	foreach ($results as $result) {
		
		?>
		<tr>
			<td><?php echo $result['id']; ?></td>
			<td><?php echo $result['name']; ?></td>
			<td style="text-align:left;"><?php echo $result['pos_zos_id']; ?>/<?php echo $result['pos_id']; ?></td>
			<td><?php echo $AllPos[''.$result['pos_id']]->name; ?></td>
			<td style="text-align:center;">
					<a href="?page=mlibOff-setup&frmType=deleteZone&id=<?php echo $result['id']; ?>" onclick='return confirm("<?php _e("Do you really want to delete this protected zone ?"); ?>")' class="mlibOff_delete"><?php _e('delete','mlibOff'); ?></a> -
					<a href="?page=mlibOff-setup&frmType=modifyZone&id=<?php echo $result['id']; ?>" class="mlibOff_delete"><?php _e('modify','mlibOff'); ?></a></td>
		</tr>
		<?php
	}
}

?>
		</tbody>
	</table>	
	
</section>

<h2><?php _e('Monelib : Configuration of the module','mlibOff'); ?></h2>
<section class="mlibOff">
	<strong><?php _e('Please follow the next steps to configure your site with Monelib :','mlibOff'); ?></strong><br /><br />
	<?php _e('Step 1 : Create your Point of Sale in Monelib then add the following URL in all the field that require to enter an URL :','mlibOff'); ?><br /><br />
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<i><?php echo get_home_url(); ?>?mlibOff=1</i><br /><br />
	<?php _e('Step 2 : Check the checkbox "Return value if accepted" (and only this one) in the "Advanced configuration" section in the bottom of your Point of Sale.','mlibOff'); ?><br />
	<?php _e('Step 3 : In this configuration area, create the protected zones you need.','mlibOff'); ?><br />
	<?php _e('Step 4 : In your page or article edition in the admin, use monelib shortcodes as in the example below.','mlibOff'); ?><br />
	<br />
	<?php _e('Single zone protection :','mlibOff');?><br />
	<pre>
		[monelibPre]
			<?php _e("The content is protected, please enter a code below :","mlibOff");?>
		
		[/monelibPre]
		[monelib zone="123" solo="true"]
		(<?php _e('Zone is the ID of the created zone, solo means that the access granted is valid only for this protection.','mlibOff'); ?>)<br />
			<?php _e("Your protected content",'mlibOff'); ?><br />
			[monelibDownload file="myvideo.mp4" text="<?php _e("Click here to download the video",'mlibOff'); ?>"]
			[monelibVideo file="myvideo.mp4" width="80%" preview="myvideopreview.jpg"]
		[/monelib]
	</pre>
	<?php _e('Multiple zones protection :','mlibOff');?><br />
	<pre>
		[monelibPre]
			<?php _e("The content is protected, please enter a code below :","mlibOff"); ?>
		
		[/monelibPre]
		[monelib zone="345, 123" solo="false, true"]
			<?php _e("Your protected content",'mlibOff'); ?><br />
			[monelibDownload file="myvideo.mp4" text="Click here to download the video"]
		[/monelib]
	</pre>	
</section>

<?php



}

// Let's check if there's something interesting for us BEFORE anything else !
function mlibOff_setup_hook_handle_post() {
	
	global $wpdb;
	
	if (isset($_REQUEST['page']) && $_REQUEST['page']== 'mlibOff-setup') mlibOff_myStartSession();
	
	if (isset($_REQUEST['frmType'])) {
		switch($_REQUEST['frmType']) {
			// Check and update the main login/password for Monelib
			case 'basic':
				if (
					!isset($_REQUEST['frmLogin'])
					|| !isset($_REQUEST['frmPassw'])
					|| !isset($_REQUEST['frmForceLang'])
				    ) exit();
				
				$res = mlibOff_getPos(trim($_REQUEST['frmLogin']), trim($_REQUEST['frmPassw']));
				if (isset($res['0'])) {
					// Erreur !!
					$_SESSION['mlibOff_admin_err'] = __('The gateway login or password is incorrect','mlibOff');
				} else {
					update_option( "mlibOff_gwlogin", trim($_REQUEST['frmLogin']));
					update_option( "mlibOff_gwpassw", trim($_REQUEST['frmPassw']));
				}
				
				update_option( "mlibOff_force_lang", trim($_REQUEST['frmForceLang']));
				
				break;
			// Check and update the protected Content form
			case 'protectedContent':
				if (
					!isset($_REQUEST['frmDir'])
					|| !isset($_REQUEST['frmEncrypt'])
				    ) exit();
				
				$dir = trim($_REQUEST['frmDir']);
				if (substr($dir, 0, 1) != '/') {
					$_dir = ABSPATH."wp-content/".$dir;
				} else $_dir = $dir;
				
				if (!is_dir($_dir)) {
					// Erreur !!
					$_SESSION['mlibOff_admin_err'] = __('The folder doesn\'t exist or is not a folder.','mlibOff');
					break;
				}
				
				update_option( "mlibOff_folder", $dir);
				
				$encrypt = trim($_REQUEST['frmEncrypt']);
				if (strlen($encrypt) < 3) {
					// Erreur !!
					$_SESSION['mlibOff_admin_err'] = __('Please enter at least 3 characters for the seed.','mlibOff');
					break;
				}
				
				update_option( "mlibOff_seed", $encrypt);
				
				$_SESSION['mlibOff_admin_err'] = __('The protected content configuration is saved.','mlibOff');
				
				break;
			// Add a protected zone (check things before)
			case 'addZone':
				if (
					!isset($_REQUEST['frmPosID'])
					|| !isset($_REQUEST['frmName'])
				    ) exit();
				
				$mlibOff_opt_login = get_option( "mlibOff_gwlogin" );
				$mlibOff_opt_passw = get_option( "mlibOff_gwpassw" );
				$res = mlibOff_getPos($mlibOff_opt_login, $mlibOff_opt_passw);
				if (isset($res['0'])) {
					// Erreur !!
					$_SESSION['mlibOff_admin_err'] = __('The gateway login or password is incorrect','mlibOff');
				} else
				if (!isset($res[''.(int)$_REQUEST['frmPosID']])) {
					// Erreur !!
					$_SESSION['mlibOff_admin_err'] = __('The POS is invalid','mlibOff');
				} else {
					$name = trim($_REQUEST['frmName']);
					if ($name == '') {
						$name = $res[''.(int)$_REQUEST['frmPosID']]->name;
					}
					
					$table_name = $wpdb->prefix . 'mliboff_zones';
					$wpdb->insert( 
						$table_name, 
						array(
							'name'=>$name,
							'pos_name'=>$res[''.(int)$_REQUEST['frmPosID']]->name,
							'pos_id'=>$res[''.(int)$_REQUEST['frmPosID']]->id,
							'pos_zos_id'=>$res[''.(int)$_REQUEST['frmPosID']]->zos,
							'pos_paytype'=>$res[''.(int)$_REQUEST['frmPosID']]->paytype
						)
					);
					if ($res === false) {
						$_SESSION['mlibOff_admin_err'] = __('There is a problem in the query','mlibOff');
					} else { 
						// Erreur !!
						$_SESSION['mlibOff_admin_err'] = __('The protected zone is inserted','mlibOff');
					}
				}
				
				break;
			// Update a protected zone (check things before)
			case 'updateZone':
				if (
					!isset($_REQUEST['frmPosID'])
					|| !isset($_REQUEST['frmName'])
					|| !isset($_REQUEST['frmID'])
				    ) exit();
				$mlibOff_opt_login = get_option( "mlibOff_gwlogin" );
				$mlibOff_opt_passw = get_option( "mlibOff_gwpassw" );
				$res = mlibOff_getPos($mlibOff_opt_login, $mlibOff_opt_passw);
				if (isset($res['0'])) {
					// Erreur !!
					$_SESSION['mlibOff_admin_err'] = __('The gateway login or password is incorrect','mlibOff');
				} else
				if (!isset($res[''.(int)$_REQUEST['frmPosID']])) {
					// Erreur !!
					$_SESSION['mlibOff_admin_err'] = __('The POS is invalid','mlibOff');
				} else {
					$name = trim($_REQUEST['frmName']);
					if ($name == '') {
						$name = $res[''.(int)$_REQUEST['frmPosID']]->name;
					}
					
					$table_name = $wpdb->prefix . 'mliboff_zones';
					$res = $wpdb->update( 
						$table_name, 
						array(
							'name'=>$name,
							'pos_name'=>$res[''.(int)$_REQUEST['frmPosID']]->name,
							'pos_id'=>$res[''.(int)$_REQUEST['frmPosID']]->id,
							'pos_zos_id'=>$res[''.(int)$_REQUEST['frmPosID']]->zos,
							'pos_paytype'=>$res[''.(int)$_REQUEST['frmPosID']]->paytype
						),
						array("id"=>(int)$_REQUEST['frmID'])
					);
					if ($res === false) {
						$_SESSION['mlibOff_admin_err'] = __('There is a problem in the query','mlibOff');
					} else { 
						// Erreur !!
						$_SESSION['mlibOff_admin_err'] = __('The protected zone is updated','mlibOff');
					}
				}
				
				break;
			// Delete a protected zone (check things before)
			case 'deleteZone':
				if (!isset($_REQUEST['id'])) exit();
				$table_name = $wpdb->prefix . 'mliboff_zones';
				$res = $wpdb->delete(
					$table_name, 
					array("id"=>(int)$_REQUEST['id'])
				);
				if ($res === false) {
					$_SESSION['mlibOff_admin_err'] = __('There is a problem in the query','mlibOff');
				} else {
					// Erreur !!
					$_SESSION['mlibOff_admin_err'] = __('The protected zone is deleted','mlibOff');
				}
				
				break;
			default:
				break;
		}
		
	}
	
	
}
add_action( 'admin_init', 'mlibOff_setup_hook_handle_post', 50 );

add_action('admin_head', 'mlibOff_style_admin');

// Some styles for the admin !
function mlibOff_style_admin() {
  echo '<style>
    section.mlibOff {
	padding-left: 20px;
    }
    section.mlibOff .legend {
	font-style: italic;
    }
    section.mlibOff td.empty {
	font-style: italic;
	padding: 30px;
	text-align: center;
    }
    section.mlibOff label {
	display: inline-block;
	width: 200px;
    }
    section.mlibOff input[type=text] {
	width: 100px;
    }
    
    section.mlibOff table {
	border-collapse: collapse;
	width: 900px;
    }
    section.mlibOff td,
    section.mlibOff th {
	border: 1px #000000 solid;
    }
  </style>';
}

?>