<?php
/**
 * @package mlibOff
 */
/*
Plugin Name: Monelib Officiel
Description: Plugin to be used with Monelib - http://www.monelib.fr/
Version: 1.4
Author: VIVA MULTIMEDIA - Monelib
Text Domain: mlibOff
Domain Path: /lang/
License:     Beerware

The purpose of this plugin is to use your created account on our website "www.monelib.com" to protect pages or articles with the monelib online payment solution.

*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// DB Version :
$mlibOff_dbversion = "1.6";

// Debug mode (which makes write in error_log)
$mlibOff_debug = true;
$mlibOff_thisValidated = false;

$mlibOff_zones = "";

$mlibOff_Pre = array();

// Document keep validated for :
define("MLIBOFF_VALID_TIME", 3600);

// Main includes :
require dirname(__FILE__)."/mlibOff_lib.php";
require dirname(__FILE__)."/mlibOff_installation.php";
require dirname(__FILE__)."/mlibOff_edit.php";
require dirname(__FILE__)."/mlibOff_admin.php";





// Main filter for the shortcode, hide the content if protected
function mlibOff_shortcode_monelib( $atts, $content = "" ) {
	global $post;
	global $mlibOff_debug;
	global $mlibOff_Pre;
	
	global $mlibOff_zones;
	
	$err_displayed = false;
	
	$results = mlibOff_getResults_static();
	
	// Defaults ...
	// solo = false means the protection is related to the zone
	// solo = true means the protection is related to the zone AND the document
	$atts = shortcode_atts( array(
		'zone' => '0',
		'solo' => 'false'
	), $atts, 'monelib' );
	
	$mlibOff_zones = $atts['zone'];
	
	$exp = explode(",",$atts['zone']);
	$exp_solo = explode(",",$atts['solo']);
	
	$protected_content = "";
	if (isset($mlibOff_Pre[$post->ID])) {
		$protected_content.= $mlibOff_Pre[$post->ID];
	}
	foreach ($exp as $index=>$mlibOff_id) {

		$mlibOff_id = (int)trim($mlibOff_id);
		$protected = false;
		foreach($results as $result) {
			if ($result['id'] == $mlibOff_id) { $protected = true; break; }
		}
		
		// Not protected because the zone has been deleted or doesn't exists... We're no longer needed.
		if (!$protected) return do_shortcode(trim($content));
		
		
		// If the document is already protected, let's goooooo
		if (isset($_SESSION['mlibOff_P'.$post->ID.'_VALID']) && $_SESSION['mlibOff_P'.$post->ID.'_VALID'] > time()) {
			// Code déjà validé sur le post ...
			$_SESSION['mlibOff_P'.$post->ID.'_VALID'] = time() + MLIBOFF_VALID_TIME;
			return do_shortcode($content);
		} elseif (isset($_SESSION['mlibOff_P'.$post->ID.'_VALID']) && $_SESSION['mlibOff_P'.$post->ID.'_VALID'] > 0) {
			
			$_SESSION['mlibOff_P'.$post->ID.'_VALID'] = 0;
			$_SESSION['mlibOff_pinErr'] = __('Your session has expired. To access the document please enter your access code below.', 'mlibOff');
			$_SESSION['mlibOff_pinErr_maxtime'] = time()+5; // 5 seconds
		}
		
		// If the zone is already protected, let's goooo
		if (isset($_SESSION['mlibOff_Z'.$mlibOff_id.'_VALID']) && $_SESSION['mlibOff_Z'.$mlibOff_id.'_VALID'] > time()) {
			// Wait a minute... We said solo = true !!! So, we validate the document and unvalidate the zone !
			if (isset($exp_solo[$index]) && trim($exp_solo[$index]) == 'true') {
				$_SESSION['mlibOff_P'.$post->ID.'_VALID'] = time() + MLIBOFF_VALID_TIME;
				$_SESSION['mlibOff_Z'.$mlibOff_id.'_VALID'] = 0;
			} else {
				$_SESSION['mlibOff_Z'.$mlibOff_id.'_VALID'] = time() + MLIBOFF_VALID_TIME;
			}
			return do_shortcode($content);
		} elseif (isset($_SESSION['mlibOff_Z'.$mlibOff_id.'_VALID']) && $_SESSION['mlibOff_Z'.$mlibOff_id.'_VALID'] > 0) {
			
			$_SESSION['mlibOff_Z'.$mlibOff_id.'_VALID'] = 0;
			$_SESSION['mlibOff_pinErr'] = __('Your session has expired. To access the document please enter your access code below.', 'mlibOff');
			$_SESSION['mlibOff_pinErr_maxtime'] = time()+5; // 5 seconds
		}
		
		// Show the payment forms ONLY if we're in the document himself.
		// Or the form is not displayed... (in lists of articles for example)
		if (is_single() || is_page()) {
				ob_start();
				$_SESSION['MLIBOFF_BACK'] = $_SERVER['REQUEST_URI'];
				$_SESSION['MLIBOFF_BACK_ID'] = $atts['zone'];
				if ($result['pos_paytype'] == '1') {
					if (!$err_displayed) { include dirname(__FILE__)."/mlibOff_tpl_header.php"; }
					include dirname(__FILE__)."/mlibOff_tpl_micropaiement.php";
				} else
				if ($result['pos_paytype'] == '2') {
					if (!$err_displayed) { include dirname(__FILE__)."/mlibOff_tpl_header.php"; }
					include dirname(__FILE__)."/mlibOff_tpl_multishot.php";
				} else
				if ($result['pos_paytype'] == '3') {
					if (!$err_displayed) { include dirname(__FILE__)."/mlibOff_tpl_header.php"; }
					include dirname(__FILE__)."/mlibOff_tpl_ezshot.php";
				}
				$err_displayed = true;
				$protected_content.= ob_get_clean();
			}
	}
	return do_shortcode(trim($protected_content));
}
add_shortcode( 'monelib', 'mlibOff_shortcode_monelib' );


// Main filter for the shortcode, hide the content if protected
function mlibOff_shortcode_monelibPre( $atts, $content = "" ) {
	global $post;
	global $mlibOff_debug;
	global $mlibOff_Pre;
	
	$mlibOff_Pre[$post->ID] = $content;
	
	return "";
}
add_shortcode( 'monelibPre', 'mlibOff_shortcode_monelibPre' );


// Main filter for the shortcode, hide the content if protected
function mlibOff_shortcode_monelibDownload( $atts ) {
	global $post;
	global $mlibOff_debug;
	
	global $mlibOff_zones;
	
	$atts = shortcode_atts( array(
		'text' => __("Download the file", "mlibOff"),
		'file' => ''
	), $atts, 'monelibDownload' );
	
	
	
	$mlibOff_opt_folder = get_option( "mlibOff_folder" );
	$mlibOff_opt_encrypt = get_option( "mlibOff_seed" );
	
	if (substr($mlibOff_opt_folder,0,1) != "/") {
		$mlibOff_opt_folder = ABSPATH."wp-content/".$mlibOff_opt_folder;
	}
	if (substr($mlibOff_opt_folder,-1,1) != "/") {
		$mlibOff_opt_folder = $mlibOff_opt_folder."/";
	}
	
	$encrypt = new mlibOff_Encryption();
	$encrypt->skey = $mlibOff_opt_encrypt;
	
	$_file = $mlibOff_opt_folder.$atts['file'];
	if (!file_exists($_file)) {
		$content = __("The file doesn't exist or have been removed, please contact administrator.");
		return $content;
	}
	
	$zones = $encrypt->encode($mlibOff_zones);
	$file = $encrypt->encode($atts['file']);
	$text = $atts['text'];
	
	
	$url = $_SERVER['REQUEST_URI'];
	if (preg_match("/\?/", $url)) {
		$url.="&";
	} else {
		$url.="?";    
	}
	$url.= "mlibOffAction=Getfile";
	$url.="&z=".$zones;
	$url.="&f=".$file;
	
	ob_start();
		include dirname(__FILE__)."/mlibOff_tpl_content_download.php";
		$content = ob_get_clean();
		
	
	
	return trim($content);
}
add_shortcode( 'monelibDownload', 'mlibOff_shortcode_monelibDownload' );


// Main filter for the shortcode, hide the content if protected
function mlibOff_shortcode_monelibVideo( $atts ) {
	global $post;
	global $mlibOff_debug;
	
	global $mlibOff_zones;
	
	$atts = shortcode_atts( array(
		'width' => '80%',
		'height' => 'auto',
		'file' => '',
		'preview' => ''
	), $atts, 'monelibVideo' );
	
	
	$mlibOff_opt_folder = get_option( "mlibOff_folder" );
	$mlibOff_opt_encrypt = get_option( "mlibOff_seed" );
	
	if (substr($mlibOff_opt_folder,0,1) != "/") {
		$mlibOff_opt_folder = ABSPATH."wp-content/".$mlibOff_opt_folder;
	}
	if (substr($mlibOff_opt_folder,-1,1) != "/") {
		$mlibOff_opt_folder = $mlibOff_opt_folder."/";
	}
	
	$encrypt = new mlibOff_Encryption();
	$encrypt->skey = $mlibOff_opt_encrypt;
	
	$_file = $mlibOff_opt_folder.$atts['file'];
	if (!file_exists($_file)) {
		$content = __("The file doesn't exist or have been removed, please contact administrator.");
		return $content;
	}
	
	
	if ($atts['preview'] != '') {
		$preview = $mlibOff_opt_folder.$atts['preview'];
		if (!file_exists($preview)) {
			$preview = '';
		} else {
			$preview = $encrypt->encode($atts['preview']);
		}
	}
	
	$zones = $encrypt->encode($mlibOff_zones);
	$file = $encrypt->encode($atts['file']);
	$width = $atts['width'];
	$height = $atts['height'];
	
	
	$url = $_SERVER['REQUEST_URI'];
	if (preg_match("/\?/", $url)) {
		$url.="&";
	} else {
		$url.="?";    
	}
	$url.= "mlibOffAction=Getfile";
	$url.="&z=".$zones;
	
	if ($preview != '') $preview = $url."&f=".$preview;
	
	$url.="&f=".$file;
	
	
	ob_start();
		include dirname(__FILE__)."/mlibOff_tpl_content_video.php";
		$content = ob_get_clean();
		
	
	
	return $content;
}
add_shortcode( 'monelibVideo', 'mlibOff_shortcode_monelibVideo' );

// Start session only if we're in a protected document !
function mlibOff_handle_wp() {
	global $mlibOff_debug;
	global $post;
	
	
	
	if (is_admin()) return;
	
	if (is_single() || is_page()) {
		
		// Protected with the shortcode ?
		if (has_shortcode($post->post_content,'monelib')) {
			mlibOff_myStartSession();
		}
		
	}
	
	if (isset($_REQUEST['mlibOffAction']) && $_REQUEST['mlibOffAction'] == 'Getfile') {
		// Let's download !!
		
		if (!isset($_REQUEST['z']) || !isset($_REQUEST['f'])) exit();
		
		$mlibOff_opt_folder = get_option( "mlibOff_folder" );
		$mlibOff_opt_encrypt = get_option( "mlibOff_seed" );
		
		if (substr($mlibOff_opt_folder,0,1) != "/") {
			$mlibOff_opt_folder = ABSPATH."wp-content/".$mlibOff_opt_folder;
		}
		if (substr($mlibOff_opt_folder,-1,1) != "/") {
			$mlibOff_opt_folder = $mlibOff_opt_folder."/";
		}
		
		$encrypt = new mlibOff_Encryption();
		$encrypt->skey = $mlibOff_opt_encrypt;
		
		$zones = $encrypt->decode($_REQUEST['z']);
		$file = $mlibOff_opt_folder.$encrypt->decode($_REQUEST['f']);
		
		if (!file_exists($file)) {
			// Let's go home
			wp_redirect(home_url());
			exit();
		}
			
		if (isset($_SESSION['mlibOff_P'.$post->ID.'_VALID']) && $_SESSION['mlibOff_P'.$post->ID.'_VALID'] > time()) {
			session_write_close();
			mlibOff_outputFile($file, basename($file));
			exit();
		}
		$exp = explode(",",$zones);
		
		$protected_content = "";
		foreach ($exp as $index=>$mlibOff_id) {	
			if (isset($_SESSION['mlibOff_Z'.$mlibOff_id.'_VALID']) && $_SESSION['mlibOff_Z'.$mlibOff_id.'_VALID'] > time()) {
				session_write_close();
				mlibOff_outputFile($file, basename($file));
				exit();
			}
		}
		
		// Let's go home
		wp_redirect(home_url());
		exit();
	}
	
}
add_action( 'wp', 'mlibOff_handle_wp', 50 );

// Let's check if there's something interesting for us BEFORE anything else !
function mlibOff_handle_monelib_return() {
	
	if (!is_admin()) {
		// We can force a lang in the front office
		$mlibOff_force_lang = get_option( "mlibOff_force_lang" );
		if ($mlibOff_force_lang == '' || $mlibOff_force_lang == 'auto') {
			if (!load_plugin_textdomain( 'mlibOff', false, basename( dirname( __FILE__ ) ) . '/lang' )) {
				load_plugin_textdomain( 'mlibOff', false, 'monelib-officiel/lang' ); // Try to force in monelib-officiel folder
			}
		} else if ($mlibOff_force_lang != 'original') {
			$moFile = dirname( __FILE__ ).'/lang/mlibOff-'.$mlibOff_force_lang.'.mo';
			if (file_exists($moFile)) {
				load_textdomain( 'mlibOff', $moFile);
			}
		}
	} else {
		// We load the default lang file...
		if (!load_plugin_textdomain( 'mlibOff', false, basename( dirname( __FILE__ ) ) . '/lang' )) {
			load_plugin_textdomain( 'mlibOff', false, 'monelib-officiel/lang' ); // Try to force in monelib-officiel folder
		}
	}
	
	if (isset($_REQUEST['mlibOff'])) {
		// We're back from Monelib website ! Let's check what we've got !
		if (!is_admin()) mlibOff_myStartSession();
		
		$result = false;
		$returnTo = home_url(); // Default to the home url !
		
		// Do we have something interesting in the session ? (we SHOULD)
		if (isset($_SESSION['MLIBOFF_BACK']) && isset($_SESSION['MLIBOFF_BACK_ID']) && $_SESSION['MLIBOFF_BACK'] != '') {
			$returnTo = $_SESSION['MLIBOFF_BACK'];
			
			$results = mlibOff_getResults_static();
			
			$exp = explode(",",$_SESSION['MLIBOFF_BACK_ID']);
			foreach ($exp as $index=>$mlibOff_id) {
				
					$mlibOff_id = (int)trim($mlibOff_id);
					foreach($results as $result) {
						if ($result['id'] == $mlibOff_id) { break; }
					}
			
					// Double check the code if available ! 
					$checkUrl = "http://www.monelib.com/accessScript/check.php?ext_frm_online=1&ext_frm_pos=".$result['pos_id']."&ext_frm_zos=".$result['pos_zos_id']."";
					$check = false;
					foreach($_REQUEST as $k=>$v) {
						if (preg_match('/^monelib_pincode([0-9]{1})$/', $k, $regs)) {
							$check = true;
							$checkUrl.= "&ext_frm_code".$regs[1]."=".rawurlencode($v);
						}
					}
					
					
					// Default to ... Toooo bad.
					// $_SESSION['mlibOff_Z'.$result['id'].'_VALID'] = 0;
					// This is a tweak ! The error message will be available for 5 seconds BECAUSE of others plugins that can launch MY filters multiple times.
					$_SESSION['mlibOff_pinErr'] = __('The pin code you entered is not valid. Please check and retry.', 'mlibOff');
					$_SESSION['mlibOff_pinErr_maxtime'] = time()+5; // 5 seconds
					
					// No code in $_REQUEST because it's not been accepted !
					if ($check) {
						global $wp_version;
						
						// I use wp_remote_get instead of Curl.
						$args = array(
							'timeout'     => 10,
							'redirection' => 5,
							'httpversion' => '1.0',
							'user-agent'  => 'WordPress/' . $wp_version . '; ' . home_url(),
							'blocking'    => true,
							'headers'     => array(),
							'cookies'     => array(),
							'body'        => null,
							'compress'    => false,
							'decompress'  => true,
							'sslverify'   => false,
							'stream'      => false,
							'filename'    => null
						); 
						$response = wp_remote_get( $checkUrl, $args );
						if( is_array($response) ) {
						  $_result = $response['body'];
						} else $_result = '';
						
						if (preg_match("/^OK/", $_result)) {
							// The payment on the zone is validated ! Thank you !
							$_SESSION['mlibOff_Z'.$result['id'].'_VALID'] = time() + MLIBOFF_VALID_TIME;
							unset($_SESSION['mlibOff_pinErr']);
							unset($_SESSION['mlibOff_pinErr_maxtime']);
							wp_redirect($returnTo);
							exit();
						}
					}
			}
			
		}
		
		// Let's go where we were before the code checking.
		wp_redirect($returnTo);
		exit();
	}
	
}
add_action( 'wp_loaded', 'mlibOff_handle_monelib_return', 50 );

// include custom jQuery
function mlibOff_jquery() {

	wp_enqueue_script('jquery');
}
add_action('wp_enqueue_scripts', 'mlibOff_jquery');
?>
