<?php
/**
 * Triggered when the plugin is uninstalled.
 *
 * @package ModernPress
 */

// Exit if accessed directly.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

global $wpdb;

// Clean up plugin options with proper caching
$option_name = 'modernpress_settings';
$cache_key = 'modernpress_settings_cache';
wp_cache_delete($cache_key, 'options');
delete_option($option_name);

// Delete custom transients using WordPress functions instead of direct query
$all_options = wp_load_alloptions(); // Load all options into memory (cached)
$transient_prefix = '_transient_modernpress_';
$transient_prefix_len = strlen($transient_prefix);

// Loop through options and delete matching transients
foreach ($all_options as $option_name => $value) {
    if (strpos($option_name, $transient_prefix) === 0) {
        $transient_name = substr($option_name, $transient_prefix_len);
        delete_transient($transient_name); // This handles both DB operations and cache
    }
}

// Clean up custom post types with WordPress functions
$post_types = ['modernpress_custom_post_type']; // Replace with your actual post types
foreach ($post_types as $post_type) {
    $cache_key = 'modernpress_uninstall_posts_' . $post_type;
    $posts = wp_cache_get($cache_key);

    if (false === $posts) {
        $posts = get_posts([
            'post_type' => $post_type,
            'posts_per_page' => -1,
            'post_status' => 'any',
            'fields' => 'ids', // Fetch only IDs for efficiency
        ]);
        wp_cache_set($cache_key, $posts);
    }

    if (!empty($posts)) {
        foreach ($posts as $post_id) {
            wp_delete_post($post_id, true);
        }
    }
}

// Drop custom table securely
$table_name = $wpdb->prefix . 'modernpress_custom_table';

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange -- Required for plugin uninstall cleanup
$wpdb->query("DROP TABLE IF EXISTS " . esc_sql($table_name));
