<?php
namespace ModernPress\Widgets;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class ModernPress_Testimonial_Widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'modernpress_testimonial_widget';
    }

    public function get_title()
    {
        return esc_html__('ModernPress Testimonial', 'modernpress-addons');
    }

    public function get_icon()
    {
        return 'eicon-testimonial';
    }

    public function get_categories()
    {
        return ['modernpress'];
    }

    public function get_keywords()
    {
        return ['testimonial', 'review', 'feedback', 'modernpress', 'slider'];
    }

    public function get_script_depends()
    {
        return ['swiper'];
    }

    public function get_style_depends()
    {
        return ['swiper'];
    }

    protected function register_controls()
    {
        // Title Section
        $this->start_controls_section(
            'testimonial_widget_title_section',
            [
                'label' => esc_html__('Widget Title', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'testimonial_widget_title',
            [
                'label' => esc_html__('Title', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Enter your widget title', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'testimonial_title_tag',
            [
                'label' => esc_html__('HTML Tag', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'h2',
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'DIV',
                    'span' => 'SPAN',
                ],
            ]
        );
        $this->add_control(
            'testimonial_title_alignment',
            [
                'label' => esc_html__('Alignment', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-left', // Elementor's left alignment icon
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-center', // Elementor's center alignment icon
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-right', // Elementor's right alignment icon
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
            ]
        );


        $this->end_controls_section();

        // Layout Settings
        $this->start_controls_section(
            'section_layout',
            [
                'label' => esc_html__('Layout Settings', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label' => esc_html__('Layout', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'modernpress-addons'),
                    'layout-2' => esc_html__('Layout 2', 'modernpress-addons'),
                    'layout-3' => esc_html__('Layout 3', 'modernpress-addons'),
                    'layout-4' => esc_html__('Layout 4', 'modernpress-addons'),
                ],
            ]
        );

        $this->add_control(
            'enable_slider',
            [
                'label' => esc_html__('Enable Slider', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'modernpress-addons'),
                'label_off' => esc_html__('No', 'modernpress-addons'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->end_controls_section();

        // Testimonials Content
        $this->start_controls_section(
            'section_testimonials',
            [
                'label' => esc_html__('Testimonials', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'avatar',
            [
                'label' => esc_html__('Avatar', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label' => esc_html__('Name', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('John Doe', 'modernpress-addons'),
                'placeholder' => esc_html__('Enter name', 'modernpress-addons'),
            ]
        );

        $repeater->add_control(
            'position',
            [
                'label' => esc_html__('Position', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('CEO at Company', 'modernpress-addons'),
                'placeholder' => esc_html__('Enter position', 'modernpress-addons'),
            ]
        );

        $repeater->add_control(
            'testimonial',
            [
                'label' => esc_html__('Testimonial', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'modernpress-addons'),
                'placeholder' => esc_html__('Enter testimonial content', 'modernpress-addons'),
            ]
        );

        $repeater->add_control(
            'rating',
            [
                'label' => esc_html__('Rating', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 5,
                        'step' => 0.5,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5,
                ],
            ]
        );

        $repeater->add_control(
            'company_logo',
            [
                'label' => esc_html__('Company Logo', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'testimonials',
            [
                'label' => esc_html__('Testimonials', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'name' => esc_html__('John Doe', 'modernpress-addons'),
                        'position' => esc_html__('CEO at Company', 'modernpress-addons'),
                        'testimonial' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'modernpress-addons'),
                    ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->end_controls_section();

        // Slider Settings
        $this->start_controls_section(
            'section_slider',
            [
                'label' => esc_html__('Slider Settings', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'enable_slider' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides Per View', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                ],
            ]
        );

        $this->add_control(
            'slides_to_scroll',
            [
                'label' => esc_html__('Slides to Scroll', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay_speed',
            [
                'label' => esc_html__('Autoplay Speed', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 3000,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Infinite Loop', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'navigation',
            [
                'label' => esc_html__('Navigation', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'pagination',
            [
                'label' => esc_html__('Pagination', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'testimonial_widget_title_style',
            [
                'label' => esc_html__('Widget Title Style', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'testimonial_widget_title_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-testimonial-widget-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'testimonial_widget_title_typography',
                'label' => esc_html__('Typography', 'modernpress-addons'),
                'selector' => '{{WRAPPER}} .modernpress-testimonial-widget-title',
            ]
        );

        $this->end_controls_section();


        // Styling Section for Testimonials
        $this->start_controls_section(
            'testimonial_style',
            [
                'label' => esc_html__('Testimonial Style', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Testimonial Text Color
        $this->add_control(
            'testimonial_text_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-testimonial-content' => 'color: {{VALUE}};',
                ],
            ]
        );

        // Testimonial Typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'testimonial_text_typography',
                'label' => esc_html__('Typography', 'modernpress-addons'),
                'selector' => '{{WRAPPER}} .modernpress-testimonial-content',
            ]
        );

        $this->end_controls_section();

        // Styling Section for Name
        $this->start_controls_section(
            'name_style',
            [
                'label' => esc_html__('Name Style', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Name Text Color
        $this->add_control(
            'name_text_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-testimonial-name' => 'color: {{VALUE}};',
                ],
            ]
        );

        // Name Typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'label' => esc_html__('Typography', 'modernpress-addons'),
                'selector' => '{{WRAPPER}} .modernpress-testimonial-name',
            ]
        );

        $this->end_controls_section();
        // Styling Section for position
        $this->start_controls_section(
            'position_style',
            [
                'label' => esc_html__('Position Style', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // position Text Color
        $this->add_control(
            'position_text_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-testimonial-position' => 'color: {{VALUE}};',
                ],
            ]
        );

        // position Typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'position_typography',
                'label' => esc_html__('Typography', 'modernpress-addons'),
                'selector' => '{{WRAPPER}} .modernpress-testimonial-position',
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $is_slider = $settings['enable_slider'] === 'yes';

        // Set alignment class based on user choice
        $title_alignment = !empty($settings['testimonial_title_alignment']) ? $settings['testimonial_title_alignment'] : 'center';

        // Render Title
        if (!empty($settings['testimonial_widget_title'])) {
            echo sprintf(
                '<%1$s class="modernpress-testimonial-widget-title align-%2$s">%3$s</%1$s>',
                esc_attr($settings['testimonial_title_tag']),
                esc_attr($title_alignment),
                esc_html($settings['testimonial_widget_title'])
            );
        }

        // Slider wrapper start
        if ($is_slider) {
            echo '<div class="modernpress-testimonial-slider swiper">';
            echo '<div class="swiper-wrapper">';
        } else {
            echo '<div class="modernpress-testimonial-grid">';
        }

        // Loop through testimonials
        foreach ($settings['testimonials'] as $index => $item) {
            if ($is_slider) {
                echo '<div class="swiper-slide">';
            }

            // Get the layout file path
            $layout_file = MODERNPRESS_PLUGIN_DIR . 'includes/widgets/includes/testimonial-widget/' . $settings['layout'] . '.php';

            if (file_exists($layout_file)) {
                // Pass individual testimonial data to layout
                $testimonial_settings = array(
                    'avatar' => $item['avatar'],
                    'name' => $item['name'],
                    'position' => $item['position'],
                    'testimonial' => $item['testimonial'],
                    'rating' => $item['rating'],
                    'company_logo' => $item['company_logo'],
                );

                // Include the layout file with local settings
                include $layout_file;
            }

            if ($is_slider) {
                echo '</div>'; // End swiper-slide
            }
        }

        // Slider wrapper end
        if ($is_slider) {
            echo '</div>'; // End swiper-wrapper

            // Add navigation
            if ($settings['navigation'] === 'yes') {
                echo '<div class="swiper-button-next"></div>';
                echo '<div class="swiper-button-prev"></div>';
            }

            // Add pagination
            if ($settings['pagination'] === 'yes') {
                echo '<div class="swiper-pagination"></div>';
            }

            echo '</div>'; // End modernpress-testimonial-slider

            // Add Swiper initialization script

            ?>

            <?php
        } else {
            echo '</div>'; // End modernpress-testimonial-grid
        }
        // Enqueue Swiper
        wp_enqueue_style(
            'swiper',
            get_template_directory_uri() . '/assets/vendor/swiper/swiper-bundle.min.css',
            array(),
            '10.3.1'
        );

        wp_enqueue_script(
            'swiper',
            get_template_directory_uri() . '/assets/vendor/swiper/swiper-bundle.min.js',
            array('jquery'),
            '10.3.1',
            true
        );
    }

}