<?php
namespace ModernPress\Widgets;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class ModernPress_Tabs_Widget extends \Elementor\Widget_Base
{
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
    }

    public function get_name()
    {
        return 'modernpress_tabs_widget';
    }

    public function get_title()
    {
        return esc_html__('ModernPress Tabs', 'modernpress-addons');
    }

    public function get_icon()
    {
        return 'eicon-tabs';
    }

    public function get_categories()
    {
        return ['modernpress'];
    }

    public function get_keywords()
    {
        return ['tabs', 'accordion', 'toggle', 'modernpress'];
    }

    protected function register_controls()
    {
        // Content Tab
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label' => esc_html__('Layout', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-1' => esc_html__('layout-1', 'modernpress-addons'),
                    'layout-2' => esc_html__('layout-2', 'modernpress-addons'),
                    'layout-3' => esc_html__('layout-3', 'modernpress-addons'),
                    'layout-4' => esc_html__('layout-4', 'modernpress-addons'),
                    'layout-5' => esc_html__('layout-5', 'modernpress-addons'),
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'tab_title',
            [
                'label' => esc_html__('Title', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Tab Title', 'modernpress-addons'),
                'placeholder' => esc_html__('Enter tab title', 'modernpress-addons'),
            ]
        );

        $repeater->add_control(
            'tab_icon',
            [
                'label' => esc_html__('Icon', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $repeater->add_control(
            'tab_content',
            [
                'label' => esc_html__('Content', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Tab Content', 'modernpress-addons'),
                'placeholder' => esc_html__('Enter tab content', 'modernpress-addons'),
            ]
        );

        $repeater->add_control(
            'tab_image',
            [
                'label' => esc_html__('Image', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'tabs',
            [
                'label' => esc_html__('Tabs', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tab_title' => esc_html__('Tab #1', 'modernpress-addons'),
                        'tab_content' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'modernpress-addons'),
                    ],
                    [
                        'tab_title' => esc_html__('Tab #2', 'modernpress-addons'),
                        'tab_content' => esc_html__('Ut enim ad minim veniam, quis nostrud exercitation ullamco.', 'modernpress-addons'),
                    ],
                ],
                'title_field' => '{{{ tab_title }}}',
            ]
        );

        $this->end_controls_section();

        // Style Tab sections remain unchanged
        // ...
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Get the layout file path
        $layout_file = MODERNPRESS_PLUGIN_DIR . 'includes/widgets/includes/tabs-widget/' . $settings['layout'] . '.php';

        if (file_exists($layout_file)) {
            include $layout_file;
        } else {
            echo esc_html__('Layout file not found.', 'modernpress-addons');
        }
    }
}