<?php
namespace ModernPress\Widgets;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class ModernPress_Table_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'modernpress_table_widget';
    }

    public function get_title()
    {
        return esc_html__('ModernPress Table', 'modernpress-addons');
    }

    public function get_icon()
    {
        return 'eicon-table';
    }

    public function get_categories()
    {
        return ['modernpress'];
    }

    public function get_keywords()
    {
        return ['table', 'data', 'grid', 'modernpress'];
    }

    protected function register_controls()
    {
        // Content Tab
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label' => esc_html__('Layout', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-1' => esc_html__('Basic Table', 'modernpress-addons'),
                    'layout-2' => esc_html__('Advanced Table', 'modernpress-addons'),
                ],
            ]
        );

        // Headers Repeater
        $header_repeater = new \Elementor\Repeater();
        $header_repeater->add_control(
            'header_text',
            [
                'label' => esc_html__('Header Text', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Header Title', 'modernpress-addons'),
                'default' => esc_html__('Column', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'table_headers',
            [
                'label' => esc_html__('Table Headers', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $header_repeater->get_controls(),
                'title_field' => '{{{ header_text }}}',
                'default' => [
                    ['header_text' => esc_html__('Column 1', 'modernpress-addons')],
                    ['header_text' => esc_html__('Column 2', 'modernpress-addons')],
                    ['header_text' => esc_html__('Column 3', 'modernpress-addons')],
                ],
            ]
        );

        // Rows Repeater
        $row_repeater = new \Elementor\Repeater();

        // Each row will have a cells repeater that matches the number of headers
        $cell_repeater = new \Elementor\Repeater();

        $cell_repeater->add_control(
            'cell_text',
            [
                'label' => esc_html__('Cell Content', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Cell content', 'modernpress-addons'),
                'default' => esc_html__('Cell', 'modernpress-addons'),
            ]
        );

        $row_repeater->add_control(
            'cells',
            [
                'label' => esc_html__('Row Cells', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $cell_repeater->get_controls(),
                'title_field' => '{{{ cell_text }}}',
                'prevent_empty' => false,
                'default' => [
                    ['cell_text' => esc_html__('Row 1, Cell 1', 'modernpress-addons')],
                    ['cell_text' => esc_html__('Row 1, Cell 2', 'modernpress-addons')],
                    ['cell_text' => esc_html__('Row 1, Cell 3', 'modernpress-addons')],
                ],
            ]
        );

        $this->add_control(
            'table_rows',
            [
                'label' => esc_html__('Table Rows', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $row_repeater->get_controls(),
                'prevent_empty' => false,
                'default' => [
                    [
                        'cells' => [
                            ['cell_text' => esc_html__('Row 1, Cell 1', 'modernpress-addons')],
                            ['cell_text' => esc_html__('Row 1, Cell 2', 'modernpress-addons')],
                            ['cell_text' => esc_html__('Row 1, Cell 3', 'modernpress-addons')],
                        ],
                    ],
                    [
                        'cells' => [
                            ['cell_text' => esc_html__('Row 2, Cell 1', 'modernpress-addons')],
                            ['cell_text' => esc_html__('Row 2, Cell 2', 'modernpress-addons')],
                            ['cell_text' => esc_html__('Row 2, Cell 3', 'modernpress-addons')],
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'show_search',
            [
                'label' => esc_html__('Show Search', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Show Pagination', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'rows_per_page',
            [
                'label' => esc_html__('Rows Per Page', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 100,
                'step' => 1,
                'default' => 10,
                'condition' => [
                    'show_pagination' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Add style controls
        $this->add_style_controls();
    }

    protected function add_style_controls()
    {
        // Style Tab - Table
        $this->start_controls_section(
            'section_table_style',
            [
                'label' => esc_html__('Table', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'table_background',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-table' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'header_background',
            [
                'label' => esc_html__('Header Background', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#DFE5F1',
                'selectors' => [
                    '{{WRAPPER}} .modernpress-table th, {{WRAPPER}} .modernpress-table .header-row th' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'alternate_row_background',
            [
                'label' => esc_html__('Alternate Row Background', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#F8F8F8',
                'selectors' => [
                    '{{WRAPPER}} .modernpress-table-layout-1 tbody tr:nth-child(even)' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .modernpress-table-layout-2 td:nth-child(even)' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
        // Header Style Controls
        $this->start_controls_section(
            'section_header_style',
            [
                'label' => esc_html__('Table Headers', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'header_text_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#1A1A1A',
                'selectors' => [
                    '{{WRAPPER}} .modernpress-table th, {{WRAPPER}} .modernpress-table .header-row th' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'header_typography',
                'selector' => '{{WRAPPER}} .modernpress-table th, {{WRAPPER}} .modernpress-table .header-row th',
            ]
        );

        $this->add_responsive_control(
            'header_align',
            [
                'label' => esc_html__('Alignment', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .modernpress-table th, {{WRAPPER}} .modernpress-table .header-row th' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Cells Style Controls
        $this->start_controls_section(
            'section_cells_style',
            [
                'label' => esc_html__('Table Cells', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'cell_text_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#4A4A4A',
                'selectors' => [
                    '{{WRAPPER}} .modernpress-table td' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'cell_typography',
                'selector' => '{{WRAPPER}} .modernpress-table td',
            ]
        );

        $this->add_responsive_control(
            'cell_align',
            [
                'label' => esc_html__('Alignment', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .modernpress-table td' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Search Style Controls
        $this->start_controls_section(
            'section_search_style',
            [
                'label' => esc_html__('Search', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_search' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'search_input_typography',
                'selector' => '{{WRAPPER}} .table-search input',
            ]
        );

        $this->add_control(
            'search_input_text_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#4B5563',
                'selectors' => [
                    '{{WRAPPER}} .table-search input' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'search_input_background',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} .table-search input' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'search_input_border',
                'selector' => '{{WRAPPER}} .table-search input',
            ]
        );

        $this->add_responsive_control(
            'search_input_border_radius',
            [
                'label' => esc_html__('Border Radius', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .table-search input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '8',
                    'right' => '8',
                    'bottom' => '8',
                    'left' => '8',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->add_control(
            'search_icon_color',
            [
                'label' => esc_html__('Icon Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#9CA3AF',
                'selectors' => [
                    '{{WRAPPER}} .table-search .search-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Entries Per Page Style Controls
        $this->start_controls_section(
            'section_entries_style',
            [
                'label' => esc_html__('Entries Per Page', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout' => 'layout-2',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'entries_typography',
                'selector' => '{{WRAPPER}} .entries-selector select',
            ]
        );

        $this->add_control(
            'entries_text_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#4B5563',
                'selectors' => [
                    '{{WRAPPER}} .entries-selector select' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'entries_background',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} .entries-selector select' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'entries_border',
                'selector' => '{{WRAPPER}} .entries-selector select',
            ]
        );

        $this->add_responsive_control(
            'entries_border_radius',
            [
                'label' => esc_html__('Border Radius', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .entries-selector select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '8',
                    'right' => '8',
                    'bottom' => '8',
                    'left' => '8',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->end_controls_section();

        // Pagination Style Controls
        $this->start_controls_section(
            'section_pagination_style',
            [
                'label' => esc_html__('Pagination', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_pagination' => 'yes',
                ],
            ]
        );

        // Info text styles
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'info_text_typography',
                'selector' => '{{WRAPPER}} .table-info',
            ]
        );

        $this->add_control(
            'info_text_color',
            [
                'label' => esc_html__('Info Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#6B7280',
                'selectors' => [
                    '{{WRAPPER}} .table-info' => 'color: {{VALUE}};',
                ],
            ]
        );

        // Page number styles
        $this->add_control(
            'page_number_heading',
            [
                'label' => esc_html__('Page Numbers', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'page_number_typography',
                'selector' => '{{WRAPPER}} .page-number',
            ]
        );

        $this->start_controls_tabs('page_number_style_tabs');

        $this->start_controls_tab(
            'page_number_normal_tab',
            [
                'label' => esc_html__('Normal', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'page_number_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#4B5563',
                'selectors' => [
                    '{{WRAPPER}} .page-number' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'page_number_background',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} .page-number' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'page_number_border',
                'selector' => '{{WRAPPER}} .page-number',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'page_number_active_tab',
            [
                'label' => esc_html__('Active', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'page_number_active_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} .page-number.active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'page_number_active_background',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2563EB',
                'selectors' => [
                    '{{WRAPPER}} .page-number.active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'page_number_active_border',
                'selector' => '{{WRAPPER}} .page-number.active',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'page_number_hover_tab',
            [
                'label' => esc_html__('Hover', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'page_number_hover_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#1F2937',
                'selectors' => [
                    '{{WRAPPER}} .page-number:hover:not(.dots):not(.active)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'page_number_hover_background',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#F3F4F6',
                'selectors' => [
                    '{{WRAPPER}} .page-number:hover:not(.dots):not(.active)' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        // Navigation arrows
        $this->add_control(
            'arrows_heading',
            [
                'label' => esc_html__('Navigation Arrows', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('arrows_style_tabs');

        $this->start_controls_tab(
            'arrows_normal_tab',
            [
                'label' => esc_html__('Normal', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'arrows_color',
            [
                'label' => esc_html__('Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#4B5563',
                'selectors' => [
                    '{{WRAPPER}} .pagination-arrow' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrows_background',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} .pagination-arrow' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'arrows_border',
                'selector' => '{{WRAPPER}} .pagination-arrow',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'arrows_hover_tab',
            [
                'label' => esc_html__('Hover', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'arrows_hover_color',
            [
                'label' => esc_html__('Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#1F2937',
                'selectors' => [
                    '{{WRAPPER}} .pagination-arrow:hover:not(:disabled)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrows_hover_background',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#F3F4F6',
                'selectors' => [
                    '{{WRAPPER}} .pagination-arrow:hover:not(:disabled)' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'arrows_disabled_tab',
            [
                'label' => esc_html__('Disabled', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'arrows_disabled_color',
            [
                'label' => esc_html__('Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#4B5563',
                'selectors' => [
                    '{{WRAPPER}} .pagination-arrow:disabled' => 'color: {{VALUE}}; opacity: 0.5;',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'arrows_size',
            [
                'label' => esc_html__('Size', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 24,
                        'max' => 60,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 36,
                ],
                'selectors' => [
                    '{{WRAPPER}} .pagination-arrow' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrows_border_radius',
            [
                'label' => esc_html__('Border Radius', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .pagination-arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '8',
                    'right' => '8',
                    'bottom' => '8',
                    'left' => '8',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Ensure headers and rows are arrays
        $headers = !empty($settings['table_headers']) ? $settings['table_headers'] : [];
        $rows = !empty($settings['table_rows']) ? $settings['table_rows'] : [];

        // Get the layout file path
        $layout_file = MODERNPRESS_PLUGIN_DIR . 'includes/widgets/includes/table-widget/' . $settings['layout'] . '.php';

        if (file_exists($layout_file)) {
            include $layout_file;
        } else {
            echo esc_html__('Layout file not found.', 'modernpress-addons');
        }
    }
}