<?php
namespace ModernPress\Widgets;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class ModernPress_Social_Icons_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'modernpress_social_icons_widget';
    }

    public function get_title()
    {
        return esc_html__('ModernPress Social Icons', 'modernpress-addons');
    }

    public function get_icon()
    {
        return 'eicon-social-icons';
    }

    public function get_categories()
    {
        return ['modernpress'];
    }

    public function get_keywords()
    {
        return ['social', 'icons', 'networks', 'modernpress'];
    }

    protected function register_controls()
    {
        // Content Tab
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label' => esc_html__('Layout', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-1' => esc_html__('layout 1', 'modernpress-addons'),
                    'layout-2' => esc_html__('layout 2', 'modernpress-addons'),
                    'layout-3' => esc_html__('layout 3', 'modernpress-addons'),
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'social_network',
            [
                'label' => esc_html__('Social Network', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'facebook',
                'options' => [
                    'facebook' => esc_html__('Facebook', 'modernpress-addons'),
                    'twitter' => esc_html__('Twitter', 'modernpress-addons'),
                    'instagram' => esc_html__('Instagram', 'modernpress-addons'),
                    'linkedin' => esc_html__('LinkedIn', 'modernpress-addons'),
                    'youtube' => esc_html__('YouTube', 'modernpress-addons'),
                    'pinterest' => esc_html__('Pinterest', 'modernpress-addons'),
                    'tiktok' => esc_html__('TikTok', 'modernpress-addons'),
                    'whatsapp' => esc_html__('WhatsApp', 'modernpress-addons'),
                    'telegram' => esc_html__('Telegram', 'modernpress-addons'),
                    'discord' => esc_html__('Discord', 'modernpress-addons'),
                    'github' => esc_html__('GitHub', 'modernpress-addons'),
                    'dribbble' => esc_html__('Dribbble', 'modernpress-addons'),
                    'behance' => esc_html__('Behance', 'modernpress-addons'),
                ],
            ]
        );

        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__('Icon', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-wordpress',
                    'library' => 'fa-brands',
                ],
                'recommended' => [
                    'fa-brands' => [
                        'facebook',
                        'twitter',
                        'instagram',
                        'linkedin',
                        'youtube',
                        'pinterest',
                        'tiktok',
                        'whatsapp',
                        'telegram',
                        'discord',
                        'github',
                        'dribbble',
                        'behance',
                    ],
                ],
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-social-profile.com', 'modernpress-addons'),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $repeater->add_control(
            'custom_color',
            [
                'label' => esc_html__('Custom Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .social-icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .social-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'social_icons',
            [
                'label' => esc_html__('Social Icons', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'social_network' => 'facebook',
                        'icon' => [
                            'value' => 'fab fa-facebook',
                            'library' => 'fa-brands',
                        ],
                        'link' => ['url' => 'https://facebook.com'],
                    ],
                    [
                        'social_network' => 'twitter',
                        'icon' => [
                            'value' => 'fab fa-twitter',
                            'library' => 'fa-brands',
                        ],
                        'link' => ['url' => 'https://twitter.com'],
                    ],
                    [
                        'social_network' => 'instagram',
                        'icon' => [
                            'value' => 'fab fa-instagram',
                            'library' => 'fa-brands',
                        ],
                        'link' => ['url' => 'https://instagram.com'],
                    ],
                ],
                'title_field' => '{{{ social_network }}}',
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => esc_html__('Alignment', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .modernpress-social-icons' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Icons Style', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__('Size', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 24,
                ],
                'selectors' => [
                    '{{WRAPPER}} .social-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .social-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .social-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icons_gap',
            [
                'label' => esc_html__('Gap Between Icons', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-social-icons' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('icon_colors');

        $this->start_controls_tab(
            'icon_colors_normal',
            [
                'label' => esc_html__('Normal', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .social-icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .social-icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .social-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'icon_colors_hover',
            [
                'label' => esc_html__('Hover', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label' => esc_html__('Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .social-icon:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .social-icon:hover i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .social-icon:hover svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Get the layout file path
        $layout_file = MODERNPRESS_PLUGIN_DIR . 'includes/widgets/includes/social-icons-widget/' . $settings['layout'] . '.php';

        if (file_exists($layout_file)) {
            include $layout_file;
        } else {
            echo esc_html__('Layout file not found.', 'modernpress-addons');
        }
    }
}