<?php
namespace ModernPress\Widgets;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class ModernPress_Search_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'modernpress_search_widget';
    }

    public function get_title()
    {
        return esc_html__('ModernPress Search', 'modernpress-addons');
    }

    public function get_icon()
    {
        return 'eicon-search';
    }

    public function get_categories()
    {
        return ['modernpress'];
    }

    public function get_keywords()
    {
        return ['search', 'filter', 'posts', 'modernpress'];
    }

    protected function register_controls()
    {
        // Content Section
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'placeholder',
            [
                'label' => esc_html__('Placeholder', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Search...', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'enable_filter',
            [
                'label' => esc_html__('Enable Filter', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'results_limit',
            [
                'label' => esc_html__('Results Limit', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5,
                'min' => 1,
                'max' => 20,
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'input_background',
            [
                'label' => esc_html__('Input Background', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-search-input' => 'background-color: {{VALUE}};',
                ],
                'default' => '#ffffff',
            ]
        );

        $this->add_control(
            'input_text_color',
            [
                'label' => esc_html__('Input Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-search-input' => 'color: {{VALUE}};',
                ],
                'default' => '#333333',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'input_border',
                'selector' => '{{WRAPPER}} .modernpress-search-input',
            ]
        );

        $this->add_responsive_control(
            'input_border_radius',
            [
                'label' => esc_html__('Border Radius', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-search-input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        // Icon Style Subsection - Add this after the existing style controls
        $this->start_controls_section(
            'section_icon_style',
            [
                'label' => esc_html__('Icons', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Icon Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .search-icon, {{WRAPPER}} .filter-icon' => 'color: {{VALUE}};',
                ],
                'default' => '#6B7280',
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label' => esc_html__('Icon Hover Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .search-icon:hover, {{WRAPPER}} .filter-icon:hover' => 'color: {{VALUE}};',
                ],
                'default' => '#0D3FB0',
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__('Icon Size', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .search-icon svg, {{WRAPPER}} .filter-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Results Style Subsection - Add this after the icon style section
        $this->start_controls_section(
            'section_results_style',
            [
                'label' => esc_html__('Results Box', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'results_background',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-search-results' => 'background-color: {{VALUE}};',
                ],
                'default' => '#ffffff',
            ]
        );

        $this->add_control(
            'results_text_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .search-result-title' => 'color: {{VALUE}};',
                ],
                'default' => '#1F2937',
            ]
        );

        $this->add_control(
            'results_excerpt_color',
            [
                'label' => esc_html__('Excerpt Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .search-result-excerpt' => 'color: {{VALUE}};',
                ],
                'default' => '#6B7280',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'results_box_shadow',
                'selector' => '{{WRAPPER}} .modernpress-search-results',
            ]
        );

        $this->add_responsive_control(
            'results_border_radius',
            [
                'label' => esc_html__('Border Radius', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-search-results' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 8,
                    'right' => 8,
                    'bottom' => 8,
                    'left' => 8,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->add_responsive_control(
            'results_padding',
            [
                'label' => esc_html__('Padding', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .search-result-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Highlight Style Subsection - Add this after the results style section
        $this->start_controls_section(
            'section_highlight_style',
            [
                'label' => esc_html__('Highlighted Text', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'highlight_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-search-results mark' => 'color: {{VALUE}};',
                ],
                'default' => '#0D3FB0',
            ]
        );

        $this->add_control(
            'highlight_background',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-search-results mark' => 'background-color: {{VALUE}};',
                ],
                'default' => 'rgba(13, 63, 176, 0.1)',
            ]
        );

        $this->add_responsive_control(
            'highlight_border_radius',
            [
                'label' => esc_html__('Border Radius', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-search-results mark' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Include the search layout
        include MODERNPRESS_PLUGIN_DIR . 'includes/widgets/includes/search-widget/layout-1.php';

        // Add AJAX handler for live search
        wp_enqueue_script(
            'modernpress-search',
            MODERNPRESS_PLUGIN_URL . 'assets/js/search.js',
            ['jquery'],
            MODERNPRESS_VERSION,
            true
        );

        // Localize script with AJAX URL and nonce
        wp_localize_script('modernpress-search', 'modernpressSearch', [
            'ajaxurl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('modernpress_search_nonce'),
            'siteUrl' => home_url(),
        ]);
    }
}