<?php
namespace ModernPress\Widgets;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class ModernPress_Heading_Block_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'modernpress_heading_block_widget';
    }

    public function get_title()
    {
        return esc_html__('ModernPress Heading', 'modernpress-addons');
    }

    public function get_icon()
    {
        return 'eicon-heading';
    }

    public function get_categories()
    {
        return ['modernpress'];
    }

    public function get_keywords()
    {
        return ['heading', 'title', 'subtitle', 'modernpress'];
    }

    protected function register_controls()
    {
        // Content Section
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label' => esc_html__('Layout', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'modernpress-addons'),
                    'layout-2' => esc_html__('Layout 2', 'modernpress-addons'),
                    'layout-3' => esc_html__('Layout 3', 'modernpress-addons'),
                    'layout-4' => esc_html__('Layout 4', 'modernpress-addons'),
                    'layout-5' => esc_html__('Layout 5', 'modernpress-addons'),
                    'layout-6' => esc_html__('Layout 6', 'modernpress-addons'),
                ],
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('Subtitle', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Subtitle', 'modernpress-addons'),
                'placeholder' => esc_html__('Enter subtitle', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Choose from our tailored product catalog', 'modernpress-addons'),
                'placeholder' => esc_html__('Enter title', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Ultrices magna pharetra aliquam commodo nec. Vel sociis imperdiet sed dui nunc. Ut tristique molestie facilisis turpis donec.', 'modernpress-addons'),
                'placeholder' => esc_html__('Type your description here', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'h2',
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                ],
            ]
        );

        $this->add_control(
            'subtitle_alignment',
            [
                'label' => esc_html__('Subtitle Alignment', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => esc_html__('start', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'end' => [
                        'title' => esc_html__('end', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-heading-left' => 'align-items: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'alignment',
            [
                'label' => esc_html__('Alignment', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-heading-container' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section - Subtitle
        $this->start_controls_section(
            'section_style_subtitle',
            [
                'label' => esc_html__('Subtitle', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-heading-subtitle' => 'color: {{VALUE}};',
                ],
                // 'default' => '#ffffff',
            ]
        );

        $this->add_control(
            'subtitle_background',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-heading-subtitle' => 'background-color: {{VALUE}};',
                ],
                // 'default' => '#0D3FB0',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .modernpress-heading-subtitle',
            ]
        );

        $this->add_responsive_control(
            'subtitle_padding',
            [
                'label' => esc_html__('Padding', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-heading-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 5,
                    'right' => 15,
                    'bottom' => 5,
                    'left' => 15,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'subtitle_border',
                'label' => esc_html__('Border', 'modernpress-addons'),
                'selector' => '{{WRAPPER}} .modernpress-heading-subtitle',
            ]
        );

        $this->add_responsive_control(
            'subtitle_border_radius',
            [
                'label' => esc_html__('Border Radius', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-heading-subtitle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->add_responsive_control(
            'subtitle_margin',
            [
                'label' => esc_html__('Margin', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-heading-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section - Title
        $this->start_controls_section(
            'section_style_title',
            [
                'label' => esc_html__('Title', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-heading-title' => 'color: {{VALUE}};',
                ],
                'default' => '#1F2937',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .modernpress-heading-title',
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__('Margin', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-heading-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section - Description
        $this->start_controls_section(
            'section_style_description',
            [
                'label' => esc_html__('Description', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-heading-description' => 'color: {{VALUE}};',
                ],
                'default' => '#6B7280',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'selector' => '{{WRAPPER}} .modernpress-heading-description',
            ]
        );

        $this->add_responsive_control(
            'description_margin',
            [
                'label' => esc_html__('Margin', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-heading-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        
        // Define the layout file path based on the selected layout
        $layout_file = MODERNPRESS_PLUGIN_DIR . 'includes/widgets/includes/heading-block-widget/' . $settings['layout'] . '.php';
        
        // Include the selected layout if the file exists, otherwise default to layout-1
        if (file_exists($layout_file)) {
            include $layout_file;
        } else {
            include MODERNPRESS_PLUGIN_DIR . 'includes/widgets/includes/heading-widget/layout-1.php';
        }
    }
}