<?php
namespace ModernPress\Widgets;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class ModernPress_Gallery_Widget extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'modernpress_gallery_widget';
    }

    public function get_title()
    {
        return esc_html__('ModernPress Gallery', 'modernpress-addons');
    }

    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }

    public function get_categories()
    {
        return ['modernpress'];
    }

    public function get_keywords()
    {
        return ['gallery', 'image', 'grid', 'modernpress'];
    }

    protected function register_controls()
    {
        // Content Tab
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label' => esc_html__('Layout', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'modernpress-addons'),
                    'layout-2' => esc_html__('Layout 2', 'modernpress-addons'),
                    'layout-3' => esc_html__('Layout 3', 'modernpress-addons'),
                    'layout-4' => esc_html__('Layout 4', 'modernpress-addons'),
                    'layout-5' => esc_html__('layout 5', 'modernpress-addons'),
                    'layout-6' => esc_html__('layout 6', 'modernpress-addons'),
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__('Choose Image', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Gallery Item', 'modernpress-addons'),
                'placeholder' => esc_html__('Enter title', 'modernpress-addons'),
            ]
        );

        $repeater->add_control(
            'category',
            [
                'label' => esc_html__('Category', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '',
                'placeholder' => esc_html__('Enter category', 'modernpress-addons'),
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'modernpress-addons'),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'gallery_items',
            [
                'label' => esc_html__('Gallery Items', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => esc_html__('Gallery Item #1', 'modernpress-addons'),
                        'category' => 'category-1',
                    ],
                    [
                        'title' => esc_html__('Gallery Item #2', 'modernpress-addons'),
                        'category' => 'category-2',
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => esc_html__('Columns', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '3',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'selectors' => [
                    '{{WRAPPER}} .gallery-grid' => 'grid-template-columns: repeat({{VALUE}}, 1fr);',
                    '{{WRAPPER}} .masonry-grid' => 'columns: {{VALUE}};',
                    '{{WRAPPER}} .metro-grid' => 'grid-template-columns: repeat({{VALUE}}, 1fr);',
                ],
            ]
        );

        $this->add_responsive_control(
            'gap',
            [
                'label' => esc_html__('Gap', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 10,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .gallery-grid' => 'gap: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .masonry-grid' => 'column-gap: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .metro-grid' => 'gap: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .carousel-track' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'image_border_width',
            [
                'label' => esc_html__('Border Width', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .gallery-item img' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'image_border_color',
            [
                'label' => esc_html__('Border Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .gallery-item img' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'image_border_style',
            [
                'label' => esc_html__('Border Style', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid' => esc_html__('Solid', 'modernpress-addons'),
                    'dashed' => esc_html__('Dashed', 'modernpress-addons'),
                    'dotted' => esc_html__('Dotted', 'modernpress-addons'),
                    'double' => esc_html__('Double', 'modernpress-addons'),
                    'none' => esc_html__('None', 'modernpress-addons'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .gallery-item img' => 'border-style: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_box_shadow',
                'selector' => '{{WRAPPER}} .gallery-item',
            ]
        );

        $this->end_controls_section();

        // Overlay Style Tab
        $this->start_controls_section(
            'section_overlay_style',
            [
                'label' => esc_html__('Overlay', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'overlay_background',
            [
                'label' => esc_html__('Overlay Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .gallery-item-overlay' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'overlay_title_color',
            [
                'label' => esc_html__('Title Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .gallery-item-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'overlay_title_typography',
                'label' => esc_html__('Typography', 'modernpress-addons'),
                'selector' => '{{WRAPPER}} .gallery-item-title',
            ]
        );
        $this->add_control(
            'overlay_category_color',
            [
                'label' => esc_html__('Category Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .gallery-item-category' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'overlay_category_typography',
                'label' => esc_html__('Typography', 'modernpress-addons'),
                'selector' => '{{WRAPPER}} .gallery-item-category',
            ]
        );

        $this->end_controls_section();
        // tabs Style Tab
        $this->start_controls_section(
            'section_tab_style',
            [
                'label' => esc_html__('Tabs', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'tab_background',
            [
                'label' => esc_html__('background', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-gallery-layout-5 .filter-button.active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tab_title_color',
            [
                'label' => esc_html__('Title Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-gallery-layout-5 .filter-button' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tab_typography',
                'label' => esc_html__('Typography', 'modernpress-addons'),
                'selector' => '{{WRAPPER}} .modernpress-gallery-layout-5 .filter-button',
            ]
        );

        $this->end_controls_section();
        // Lightbox Settings
        $this->start_controls_section(
            'section_lightbox',
            [
                'label' => esc_html__('Lightbox', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'enable_lightbox',
            [
                'label' => esc_html__('Enable Lightbox', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'lightbox_animation',
            [
                'label' => esc_html__('Animation', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'zoom',
                'options' => [
                    'zoom' => esc_html__('Zoom', 'modernpress-addons'),
                    'fade' => esc_html__('Fade', 'modernpress-addons'),
                    'slide' => esc_html__('Slide', 'modernpress-addons'),
                ],
                'condition' => [
                    'enable_lightbox' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Get the layout file path
        $layout_file = MODERNPRESS_PLUGIN_DIR . 'includes/widgets/includes/gallery-widget/' . $settings['layout'] . '.php';

        if (file_exists($layout_file)) {
            include $layout_file;
        } else {
            echo esc_html__('Layout file not found.', 'modernpress-addons');
        }
    }
}