<?php
namespace ModernPress\Widgets;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class ModernPress_Content_Block_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'modernpress_content_block_widget';
    }

    public function get_title()
    {
        return esc_html__('ModernPress Content Block', 'modernpress-addons');
    }

    public function get_icon()
    {
        return 'eicon-columns';
    }

    public function get_categories()
    {
        return ['modernpress'];
    }

    public function get_keywords()
    {
        return ['content', 'block', 'info', 'feature', 'section', 'modernpress'];
    }

    protected function register_controls()
    {
        // Content Section
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label' => esc_html__('Layout', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'modernpress-addons'),
                    'layout-2' => esc_html__('Layout 2', 'modernpress-addons'),
                    'layout-3' => esc_html__('Layout 3', 'modernpress-addons'),
                    'layout-4' => esc_html__('Layout 4', 'modernpress-addons'),
                    'layout-5' => esc_html__('Layout 5', 'modernpress-addons'),
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Premium Features for Your Website', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Build beautiful websites with our premium WordPress theme. Modern design, powerful features, and exceptional support all in one package.', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => esc_html__('Button Text', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Learn More', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'button_link',
            [
                'label' => esc_html__('Button Link', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'modernpress-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );

        $this->add_control(
            'show_button_icon',
            [
                'label' => esc_html__('Show Button Icon', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'modernpress-addons'),
                'label_off' => esc_html__('No', 'modernpress-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'button_icon',
            [
                'label' => esc_html__('Button Icon', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-arrow-right',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'show_button_icon' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_alignment',
            [
                'label' => esc_html__('Content Alignment', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'modernpress-addons'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-text' => 'text-align: {{VALUE}};',
                    '{{WRAPPER}} .modernpress-content-block-header' => 'text-align: {{VALUE}};',
                    '{{WRAPPER}} .modernpress-content-block-button-wrapper' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__('Choose Image', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'image',
                'default' => 'large',
                'separator' => 'none',
            ]
        );

        $this->add_control(
            'image_position',
            [
                'label' => esc_html__('Image Position', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'right',
                'options' => [
                    'left' => esc_html__('Left', 'modernpress-addons'),
                    'right' => esc_html__('Right', 'modernpress-addons'),
                ],
                'condition' => [
                    'layout' => ['layout-1', 'layout-2', 'layout-3'],
                ],
            ]
        );

        $this->add_control(
            'items_heading',
            [
                'label' => esc_html__('Numbered Items', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'layout' => 'layout-4',
                ],
            ]
        );
        
        $repeater = new \Elementor\Repeater();
        
        $repeater->add_control(
            'item_title',
            [
                'label' => esc_html__('Item Title', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Item Title', 'modernpress-addons'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'item_heading',
            [
                'label' => esc_html__('Item Heading', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Item Heading', 'modernpress-addons'),
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'item_description',
            [
                'label' => esc_html__('Item Description', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Item description goes here. Add your content to explain this feature or benefit.', 'modernpress-addons'),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'item_title' => esc_html__('Feature One', 'modernpress-addons'),
                        'item_description' => esc_html__('Describe your first key feature or benefit here. Keep it short and compelling.', 'modernpress-addons'),
                    ],
                    [
                        'item_title' => esc_html__('Feature Two', 'modernpress-addons'),
                        'item_description' => esc_html__('Describe your second key feature or benefit here. Focus on the value it provides.', 'modernpress-addons'),
                    ],
                    [
                        'item_title' => esc_html__('Feature Three', 'modernpress-addons'),
                        'item_description' => esc_html__('Describe your third key feature or benefit here. Highlight what makes it special.', 'modernpress-addons'),
                    ],
                ],
                'title_field' => '{{{ item_title }}}',
                'condition' => [
                    'layout' => 'layout-4',
                ],
            ]
        );
        $this->add_control(
            'tabs_heading',
            [
                'label' => esc_html__('Tabs Items', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'layout' => 'layout-5',
                ],
            ]
        );
        
        // Use the same repeater structure for tabs
        $this->add_control(
            'items_layout5',
            [
                'label' => esc_html__('Tabs', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'item_title' => esc_html__('Tab One', 'modernpress-addons'),
                        'item_heading' => esc_html__('First Tab Heading', 'modernpress-addons'),
                        'item_description' => esc_html__('Content for the first tab goes here. Explain features, benefits or details related to this tab.', 'modernpress-addons'),
                    ],
                    [
                        'item_title' => esc_html__('Tab Two', 'modernpress-addons'),
                        'item_heading' => esc_html__('Second Tab Heading', 'modernpress-addons'),
                        'item_description' => esc_html__('Content for the second tab goes here. Add specific information that makes this section stand out.', 'modernpress-addons'),
                    ],
                    [
                        'item_title' => esc_html__('Tab Three', 'modernpress-addons'),
                        'item_heading' => esc_html__('Third Tab Heading', 'modernpress-addons'),
                        'item_description' => esc_html__('Content for the third tab goes here. Showcase unique selling points or important details.', 'modernpress-addons'),
                    ],
                ],
                'title_field' => '{{{ item_title }}}',
                'condition' => [
                    'layout' => 'layout-5',
                ],
            ]
        );
        $this->end_controls_section();
        // Additional style control section for numbered items
        // Add this as a new section after the image style section
        
        $this->start_controls_section(
            'section_numbered_items_style',
            [
                'label' => esc_html__('Numbered Items', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout' => 'layout-4',
                ],
            ]
        );
        
        $this->add_control(
            'divider_color',
            [
                'label' => esc_html__('Divider Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-divider' => 'border-color: {{VALUE}};',
                ],
                'default' => '#E5E7EB',
            ]
        );
        
        $this->add_control(
            'divider_style',
            [
                'label' => esc_html__('Divider Style', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'solid' => esc_html__('Solid', 'modernpress-addons'),
                    'dashed' => esc_html__('Dashed', 'modernpress-addons'),
                    'dotted' => esc_html__('Dotted', 'modernpress-addons'),
                    'double' => esc_html__('Double', 'modernpress-addons'),
                ],
                'default' => 'solid',
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-divider' => 'border-top-style: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'divider_width',
            [
                'label' => esc_html__('Divider Width', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 2,
                ],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-divider' => 'border-top-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'number_circle_color',
            [
                'label' => esc_html__('Number Circle Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-item-number .number-circle' => 'border-color: {{VALUE}}; color: {{VALUE}};',
                ],
                'default' => '#0D3FB0',
            ]
        );
        
        $this->add_control(
            'number_circle_size',
            [
                'label' => esc_html__('Number Circle Size', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-item-number .number-circle' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'number_typography',
                'selector' => '{{WRAPPER}} .modernpress-content-block-item-number .number-circle',
            ]
        );
        
        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__('Item Title Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-item-title' => 'color: {{VALUE}};',
                ],
                'default' => '#1F2937',
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_title_typography',
                'selector' => '{{WRAPPER}} .modernpress-content-block-item-title',
            ]
        );
        
        $this->add_control(
            'item_description_color',
            [
                'label' => esc_html__('Item Description Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-item-description' => 'color: {{VALUE}};',
                ],
                'default' => '#4B5563',
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_description_typography',
                'selector' => '{{WRAPPER}} .modernpress-content-block-item-description',
            ]
        );
        
        $this->add_responsive_control(
            'item_spacing',
            [
                'label' => esc_html__('Item Bottom Spacing', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-item:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
            ]
        );
        
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tabs_style',
            [
                'label' => esc_html__('Tabs', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout' => 'layout-5',
                ],
            ]
        );
        
        $this->add_control(
            'tabs_container_background',
            [
                'label' => esc_html__('Pills Container Background', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-tabs-pills' => 'background-color: {{VALUE}};',
                ],
                'default' => '#F5F5F5',
            ]
        );
        
        $this->add_control(
            'tabs_container_border_radius',
            [
                'label' => esc_html__('Pills Container Border Radius', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-tabs-pills' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->start_controls_tabs('tabs_styles_tabs');
        
        $this->start_controls_tab(
            'tabs_normal',
            [
                'label' => esc_html__('Normal', 'modernpress-addons'),
            ]
        );
        
        $this->add_control(
            'tab_text_color',
            [
                'label' => esc_html__('Tab Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-tab-pill' => 'color: {{VALUE}};',
                ],
                'default' => '#666666',
            ]
        );
        
        $this->add_control(
            'tab_background_color',
            [
                'label' => esc_html__('Tab Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-tab-pill' => 'background-color: {{VALUE}};',
                ],
                'default' => 'transparent',
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'tabs_active',
            [
                'label' => esc_html__('Active', 'modernpress-addons'),
            ]
        );
        
        $this->add_control(
            'active_tab_text_color',
            [
                'label' => esc_html__('Tab Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-tab-pill.active' => 'color: {{VALUE}};',
                ],
                'default' => '#FFFFFF',
            ]
        );
        
        $this->add_control(
            'active_tab_background_color',
            [
                'label' => esc_html__('Tab Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-tab-pill.active' => 'background-color: {{VALUE}};',
                ],
                'default' => '#0D3FB0',
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'tabs_hover',
            [
                'label' => esc_html__('Hover', 'modernpress-addons'),
            ]
        );
        
        $this->add_control(
            'hover_tab_text_color',
            [
                'label' => esc_html__('Tab Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-tab-pill:hover:not(.active)' => 'color: {{VALUE}};',
                ],
                'default' => '#0D3FB0',
            ]
        );
        
        $this->add_control(
            'hover_tab_background_color',
            [
                'label' => esc_html__('Tab Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-tab-pill:hover:not(.active)' => 'background-color: {{VALUE}};',
                ],
                'default' => 'rgba(13, 63, 176, 0.1)',
            ]
        );
        
        $this->end_controls_tab();
        
        $this->end_controls_tabs();
        
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tab_typography',
                'selector' => '{{WRAPPER}} .modernpress-tab-pill',
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'tab_heading_color',
            [
                'label' => esc_html__('Tab Heading Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-tab-heading' => 'color: {{VALUE}};',
                ],
                'default' => '#1F2937',
                'separator' => 'before',
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tab_heading_typography',
                'selector' => '{{WRAPPER}} .modernpress-tab-heading',
            ]
        );
        
        $this->add_control(
            'tab_heading_spacing',
            [
                'label' => esc_html__('Heading Bottom Spacing', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-tab-heading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'tab_border_radius',
            [
                'label' => esc_html__('Tab Border Radius', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-tab-pill' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'tab_padding',
            [
                'label' => esc_html__('Tab Padding', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-tab-pill' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 10,
                    'right' => 20,
                    'bottom' => 10,
                    'left' => 20,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
            ]
        );
        
        $this->add_control(
            'tab_content_color',
            [
                'label' => esc_html__('Tab Content Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-tab-description' => 'color: {{VALUE}};',
                ],
                'default' => '#4B5563',
                'separator' => 'before',
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tab_content_typography',
                'selector' => '{{WRAPPER}} .modernpress-tab-description',
            ]
        );
        
        $this->add_control(
            'tab_content_padding',
            [
                'label' => esc_html__('Content Padding', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-tab-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 15,
                    'right' => 0,
                    'bottom' => 15,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
            ]
        );
        
        $this->end_controls_section();

        // Style Section - Container
        $this->start_controls_section(
            'section_container_style',
            [
                'label' => esc_html__('Container', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'container_background',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-container' => 'background-color: {{VALUE}};',
                ],
                'default' => '#FFFFFF',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'container_border',
                'selector' => '{{WRAPPER}} .modernpress-content-block-container',
            ]
        );

        $this->add_responsive_control(
            'container_border_radius',
            [
                'label' => esc_html__('Border Radius', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 8,
                    'right' => 8,
                    'bottom' => 8,
                    'left' => 8,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->add_responsive_control(
            'container_padding',
            [
                'label' => esc_html__('Padding', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 30,
                    'right' => 30,
                    'bottom' => 30,
                    'left' => 30,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'container_box_shadow',
                'selector' => '{{WRAPPER}} .modernpress-content-block-container',
            ]
        );

        $this->end_controls_section();

        // Style Section - Typography
        $this->start_controls_section(
            'section_typography',
            [
                'label' => esc_html__('Typography', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Title Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-title' => 'color: {{VALUE}};',
                ],
                'default' => '#1F2937',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .modernpress-content-block-title',
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => esc_html__('Description Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-description' => 'color: {{VALUE}};',
                ],
                'default' => '#4B5563',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'selector' => '{{WRAPPER}} .modernpress-content-block-description',
            ]
        );

        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => esc_html__('Title Bottom Spacing', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
            ]
        );

        $this->add_responsive_control(
            'description_spacing',
            [
                'label' => esc_html__('Description Bottom Spacing', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-description' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 25,
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section - Button
        $this->start_controls_section(
            'section_button_style',
            [
                'label' => esc_html__('Button', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('button_style_tabs');

        $this->start_controls_tab(
            'button_normal',
            [
                'label' => esc_html__('Normal', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-btn' => 'color: {{VALUE}};',
                ],
                'default' => '#0D3FB0',
            ]
        );

        $this->add_control(
            'button_background_color',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-btn' => 'background-color: {{VALUE}};',
                ],
                'default' => '#FFFFFF',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .modernpress-content-block-btn',
                'default' => [
                    'color' => '#0D3FB0',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_hover',
            [
                'label' => esc_html__('Hover', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'button_hover_text_color',
            [
                'label' => esc_html__('Text Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-btn:hover' => 'color: {{VALUE}};',
                ],
                'default' => '#FFFFFF',
            ]
        );

        $this->add_control(
            'button_hover_background_color',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-btn:hover' => 'background-color: {{VALUE}};',
                ],
                'default' => '#0D3FB0',
            ]
        );

        $this->add_control(
            'button_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-btn:hover' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'button_border_border!' => '',
                ],
                'default' => '#0D3FB0',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
            'button_border_radius',
            [
                'label' => esc_html__('Border Radius', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
                'default' => [
                    'top' => 8,
                    'right' => 8,
                    'bottom' => 8,
                    'left' => 8,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => esc_html__('Padding', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 12,
                    'right' => 24,
                    'bottom' => 12,
                    'left' => 24,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .modernpress-content-block-btn',
            ]
        );

        $this->add_control(
            'button_icon_spacing',
            [
                'label' => esc_html__('Icon Spacing', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-btn .btn-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_button_icon' => 'yes',
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 8,
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section - Image
        $this->start_controls_section(
            'section_image_style',
            [
                'label' => esc_html__('Image', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'image_width',
            [
                'label' => esc_html__('Width', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-image img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_max_width',
            [
                'label' => esc_html__('Max Width', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-image img' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_height',
            [
                'label' => esc_html__('Height', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'vh'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    'vh' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-image img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_object_fit',
            [
                'label' => esc_html__('Object Fit', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'cover' => esc_html__('Cover', 'modernpress-addons'),
                    'contain' => esc_html__('Contain', 'modernpress-addons'),
                    'fill' => esc_html__('Fill', 'modernpress-addons'),
                    'none' => esc_html__('None', 'modernpress-addons'),
                ],
                'default' => 'cover',
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-image img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'image_border',
                'selector' => '{{WRAPPER}} .modernpress-content-block-image img',
            ]
        );

        $this->add_responsive_control(
            'image_border_radius',
            [
                'label' => esc_html__('Border Radius', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-content-block-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 8,
                    'right' => 8,
                    'bottom' => 8,
                    'left' => 8,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_box_shadow',
                'selector' => '{{WRAPPER}} .modernpress-content-block-image img',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $layout = $settings['layout'];

        // Include the selected layout
        include MODERNPRESS_PLUGIN_DIR . 'includes/widgets/includes/content-block/' . $layout . '.php';

        
    }
}