<?php
namespace ModernPress\Widgets;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class ModernPress_Category_Tabs_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'modernpress_category_tabs_widget';
    }

    public function get_title()
    {
        return esc_html__('ModernPress Category Tabs', 'modernpress-addons');
    }

    public function get_icon()
    {
        return 'eicon-tabs';
    }

    public function get_categories()
    {
        return ['modernpress'];
    }

    public function get_keywords()
    {
        return ['category', 'tabs', 'posts', 'blog', 'modernpress-addons'];
    }

    protected function register_controls()
    {
        // Content Tab
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label' => esc_html__('Layout', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'modernpress-addons'),
                    'layout-2' => esc_html__('Layout 2', 'modernpress-addons'),
                    'layout-3' => esc_html__('Layout 3', 'modernpress-addons'),
                    'layout-4' => esc_html__('Layout 4', 'modernpress-addons'),
                ],
            ]
        );

        // Get all categories
        $categories = get_categories([
            'orderby' => 'name',
            'order' => 'ASC',
            'hide_empty' => true,
        ]);

        $category_options = [];
        foreach ($categories as $category) {
            $category_options[$category->term_id] = $category->name;
        }

        $this->add_control(
            'selected_categories',
            [
                'label' => esc_html__('Select Categories', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $category_options,
                'default' => array_keys($category_options), // Select all by default
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => esc_html__('Posts Per Category', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 20,
                'step' => 1,
                'default' => 4,
            ]
        );

        $this->add_control(
            'show_thumbnail',
            [
                'label' => esc_html__('Show Featured Image', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'modernpress-addons'),
                'label_off' => esc_html__('Hide', 'modernpress-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_excerpt',
            [
                'label' => esc_html__('Show Excerpt', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'modernpress-addons'),
                'label_off' => esc_html__('Hide', 'modernpress-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'excerpt_length',
            [
                'label' => esc_html__('Excerpt Length', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 10,
                'max' => 200,
                'step' => 5,
                'default' => 20,
                'condition' => [
                    'show_excerpt' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Tab - Tabs Navigation
        $this->start_controls_section(
            'section_tabs_navigation_style',
            [
                'label' => esc_html__('Tabs Navigation', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'tab_color',
            [
                'label' => esc_html__('Tab Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tab-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'active_tab_color',
            [
                'label' => esc_html__('Active Tab Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tabs-navigation .active span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'hover_tab_color',
            [
                'label' => esc_html__('Hover Tab Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tab-title:hover span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tab_typography',
                'selector' => '{{WRAPPER}} .tab-text',
            ]
        );

        $this->end_controls_section();

        // Style Tab - Posts
        $this->start_controls_section(
            'section_posts_style',
            [
                'label' => esc_html__('Posts', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'post_title_color',
            [
                'label' => esc_html__('Post Title Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'post_excerpt_color',
            [
                'label' => esc_html__('Post Excerpt Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-excerpt' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'post_title_typography',
                'label' => esc_html__('Title Typography', 'modernpress-addons'),
                'selector' => '{{WRAPPER}} .post-title a',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'post_excerpt_typography',
                'label' => esc_html__('Excerpt Typography', 'modernpress-addons'),
                'selector' => '{{WRAPPER}} .post-excerpt',
            ]
        );
        // tab setting 
        $this->add_control(
            'tab_background_color',
            [
                'label' => esc_html__('Tab Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tabs-navigation .active ' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'tab_hover_background_color',
            [
                'label' => esc_html__('Tab Hover Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tabs-navigation .tab-title:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        // tag Color
        $this->add_control(
            'tag_color',
            [
                'label' => esc_html__('Tag Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-tag' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'tag_hover_color',
            [
                'label' => esc_html__('Tag Hover Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-tag:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        // Description Typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tag_typography',
                'label' => esc_html__('Tag Typography', 'modernpress-addons'),
                'selector' => '{{WRAPPER}} .category-tag',
            ]
        );
        $this->add_control(
            'tag_background_color',
            [
                'label' => esc_html__('Tag Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-tag' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'tag_hover_background_color',
            [
                'label' => esc_html__('Tag Hover Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category-tag:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // link Color
        $this->add_control(
            'link_color',
            [
                'label' => esc_html__('Link Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .read-more' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'link_typography',
                'label' => esc_html__('Link Typography', 'modernpress-addons'),
                'selector' => '{{WRAPPER}} .read-more',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Get the layout file path
        $layout_file = MODERNPRESS_PLUGIN_DIR . 'includes/widgets/includes/category-tabs-widget/' . $settings['layout'] . '.php';

        if (file_exists($layout_file)) {
            include $layout_file;
        } else {
            echo esc_html__('Layout file not found.', 'modernpress-addons');
        }
    }
}