<?php
namespace ModernPress\Widgets;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class ModernPress_Card_Widget extends \Elementor\Widget_Base
{

    private $default_image;

    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        $this->default_image = MODERNPRESS_PLUGIN_URL . 'assets/images/placeholder.png';
    }

    public function get_name()
    {
        return 'modernpress_card_widget';
    }

    public function get_title()
    {
        return esc_html__('ModernPress Card', 'modernpress-addons');
    }

    public function get_icon()
    {
        return 'eicon-ehp-cta';
    }

    public function get_categories()
    {
        return ['modernpress'];
    }

    public function get_keywords()
    {
        return ['card', 'box', 'info', 'modernpress'];
    }

    protected function register_controls()
    {
        // Content Tab
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label' => esc_html__('Layout', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'modernpress-addons'),
                    'layout-2' => esc_html__('Layout 2', 'modernpress-addons'),
                    'layout-3' => esc_html__('Layout 3', 'modernpress-addons'),
                    'layout-4' => esc_html__('Layout 4', 'modernpress-addons'),
                    'layout-5' => esc_html__('Layout 5', 'modernpress-addons'),
                    'layout-6' => esc_html__('Layout 6', 'modernpress-addons'),
                ],
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__('Choose Image', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => $this->default_image,
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Top Figma plugins to use for responsive design', 'modernpress-addons'),
                'placeholder' => esc_html__('Enter your title', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Aliquam eu vulputate erat sollicitudin vel scelerisque. Sit consequat nibh sed viverra turpis venenatis et. Ultrices vitae duis risus tristique feugiat vulputate scelerisque.', 'modernpress-addons'),
                'placeholder' => esc_html__('Enter your description', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => esc_html__('Button Text', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Read More', 'modernpress-addons'),
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'modernpress-addons'),
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Card Style', 'modernpress-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'card_background_color',
            [
                'label' => esc_html__('Background Color', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .modernpress-card' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .modernpress-card-content' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'card_border',
                'selector' => '{{WRAPPER}} .modernpress-card',
            ]
        );

        $this->add_responsive_control(
            'card_border_radius',
            [
                'label' => esc_html__('Border Radius', 'modernpress-addons'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .modernpress-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'card_box_shadow',
                'selector' => '{{WRAPPER}} .modernpress-card',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Handle empty image case
        if (empty($settings['image']['url'])) {
            $settings['image'] = [
                'url' => $this->default_image,
                'id' => '',
            ];
        }

        // Get the layout file path
        $layout_file = MODERNPRESS_PLUGIN_DIR . 'includes/widgets/includes/card-widget/' . $settings['layout'] . '.php';

        if (file_exists($layout_file)) {
            include $layout_file;
        } else {
            echo esc_html__('Layout file not found.', 'modernpress-addons');
        }
    }
}