<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Now using $testimonial_settings instead of $settings for individual testimonial data
$avatar = $testimonial_settings['avatar'];
$name = $testimonial_settings['name'];
$position = $testimonial_settings['position'];
$testimonial = $testimonial_settings['testimonial'];
$rating = $testimonial_settings['rating'];
$company_logo = $testimonial_settings['company_logo'];
?>

<div class="modernpress-testimonial modernpress-testimonial-layout-4">

    <?php if (isset($rating['size']) && $rating['size'] > 0): ?>
        <div class="modernpress-testimonial-rating">
            <?php
            $full_stars = floor($rating['size']);
            $half_star = ($rating['size'] - $full_stars) >= 0.5;
            $empty_stars = 5 - ceil($rating['size']);

            // Full stars
            for ($i = 0; $i < $full_stars; $i++) {
                echo '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" class="star-full">
                        <path d="M12 2l2.4 7.4h7.6l-6.2 4.5 2.4 7.4-6.2-4.5-6.2 4.5 2.4-7.4-6.2-4.5h7.6z"/>
                    </svg>';
            }

            // Half star
            if ($half_star) {
                echo '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" class="star-half">
                        <defs>
                            <linearGradient id="half" x1="0%" y1="0%" x2="100%" y2="0%">
                                <stop offset="50%" style="stop-color:currentColor;stop-opacity:1" />
                                <stop offset="50%" style="stop-color:#E2E8F0;stop-opacity:1" />
                            </linearGradient>
                        </defs>
                        <path fill="url(#half)" d="M12 2l2.4 7.4h7.6l-6.2 4.5 2.4 7.4-6.2-4.5-6.2 4.5 2.4-7.4-6.2-4.5h7.6z"/>
                    </svg>';
            }

            // Empty stars
            for ($i = 0; $i < $empty_stars; $i++) {
                echo '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" class="star-empty">
                        <path d="M12 2l2.4 7.4h7.6l-6.2 4.5 2.4 7.4-6.2-4.5-6.2 4.5 2.4-7.4-6.2-4.5h7.6z"/>
                    </svg>';
            }
            ?>
        </div>
    <?php endif; ?>

    <?php if ($testimonial): ?>
        <div class="modernpress-testimonial-content">
            <?php echo wp_kses_post($testimonial); ?>
        </div>
    <?php endif; ?>

    <div class="modernpress-testimonial-below-content">
        <!-- <div class="modernpress-testimonial-avatar">
            <?php
            if (!empty($avatar['id'])) {
                echo wp_get_attachment_image($avatar['id'], 'thumbnail');
            } else {
                // Use Elementor's methods to render the image
                echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($item, 'avatar'));
                // echo '<img src="' . esc_url($avatar['url']) . '" alt="' . esc_attr($name) . '">';
            }
            ?>
        </div> -->
        <div class="modernpress-testimonial-creds">
            <?php if ($name): ?>
                <div class="modernpress-testimonial-name">
                    <?php echo esc_html($name); ?>
                </div>
            <?php endif; ?>
            <?php if ($position): ?>
                <div class="modernpress-testimonial-position">
                    <?php echo esc_html($position); ?>
                </div>
            <?php endif; ?>
        </div>
        <?php if (!empty($company_logo['url'])): ?>
            <div class="modernpress-testimonial-company-logo">
                <?php
                if (!empty($company_logo['id'])) {
                    echo wp_get_attachment_image($company_logo['id'], 'medium');
                } else {
                    // Use Elementor's methods to render the image
                    echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($item, 'company_logo'));
                    // echo '<img src="' . esc_url($company_logo['url']) . '" alt="' . esc_attr__('Company Logo', 'modernpress') . '">';
                }
                ?>
            </div>
        <?php endif; ?>

    </div>
</div>