<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$team_members = $settings['team_members'];
?>

<div class="modernpress-team modernpress-team-layout-6">
    <div class="team-grid">
        <?php foreach ($team_members as $index => $member): ?>
            <div class="team-member">
                <div class="member-inner">


                    <div class="member-content">
                        <div class="member-image-wrapper">
                            <?php
                            $image_url = !empty($member['image']['url']) ? $member['image']['url'] : $this->default_image;
                            ?>
                            <div class="member-image">
                                <?php
                                // Use Elementor's methods to render the image
                                echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($member, 'image'));
                                ?>
                            </div>

                        </div>
                        <h3 class="member-name"><?php echo esc_html($member['name']); ?></h3>
                        <span class="member-position"><?php echo esc_html($member['position']); ?></span>
                        <div class="member-bio"><?php echo wp_kses_post($member['bio']); ?></div>

                        <?php if (!empty($member['custom_link']['url'])): ?>
                            <a href="<?php echo esc_url($member['custom_link']['url']); ?>" class="member-link" <?php echo $member['custom_link']['is_external'] ? 'target="_blank"' : ''; ?>>
                                <span>View Profile</span>
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M4.16669 10H15.8334M15.8334 10L10 4.16669M15.8334 10L10 15.8334"
                                        stroke="currentColor" stroke-width="1.67" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                </svg>
                            </a>
                        <?php endif; ?>
                        <div class="member-overlay">
                            <div class="member-social">
                                <?php if (!empty($member['linkedin']['url'])): ?>
                                    <a href="<?php echo esc_url($member['linkedin']['url']); ?>" class="social-link linkedin"
                                        <?php echo $member['linkedin']['is_external'] ? 'target="_blank"' : ''; ?>>
                                        <svg width="17" height="16" viewBox="0 0 17 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M1.05669 3.16856C0.677069 2.8161 0.488281 2.37982 0.488281 1.86072C0.488281 1.34162 0.678078 0.886132 1.05669 0.53266C1.4363 0.180199 1.92496 0.00346375 2.52367 0.00346375C3.12237 0.00346375 3.59186 0.180199 3.97046 0.53266C4.35008 0.885122 4.53887 1.32849 4.53887 1.86072C4.53887 2.39295 4.34907 2.8161 3.97046 3.16856C3.59085 3.52102 3.10925 3.69775 2.52367 3.69775C1.93809 3.69775 1.4363 3.52102 1.05669 3.16856ZM4.21984 5.19042V15.9965H0.806302V5.19042H4.21984Z"
                                                fill="black" />
                                            <path
                                                d="M15.5825 6.25788C16.3266 7.06581 16.6981 8.17472 16.6981 9.58659V15.8056H13.4562V10.0249C13.4562 9.31289 13.2715 8.75946 12.903 8.36559C12.5344 7.97172 12.0377 7.77377 11.4158 7.77377C10.7939 7.77377 10.2971 7.97071 9.92859 8.36559C9.56007 8.75946 9.37531 9.31289 9.37531 10.0249V15.8056H6.11426V5.16011H9.37531V6.57197C9.70546 6.10135 10.1507 5.7297 10.7101 5.45601C11.2694 5.18232 11.8984 5.04597 12.598 5.04597C13.8439 5.04597 14.8394 5.44994 15.5825 6.25788Z"
                                                fill="black" />
                                        </svg>
                                    </a>
                                <?php endif; ?>

                                <?php if (!empty($member['twitter']['url'])): ?>
                                    <a href="<?php echo esc_url($member['twitter']['url']); ?>" class="social-link twitter"
                                        <?php echo $member['twitter']['is_external'] ? 'target="_blank"' : ''; ?>>
                                        <svg width="17" height="16" viewBox="0 0 17 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M0.737958 0.460709L6.95657 8.77732L0.699219 15.5393H2.10791L7.58675 9.61939L12.0131 15.5393H16.806L10.2378 6.75488L16.0625 0.460709H14.6538L9.60859 5.91283L5.53183 0.460709H0.738893H0.737958ZM2.80893 1.49842H5.0103L14.7331 14.5016H12.5318L2.80893 1.49842Z"
                                                fill="black" />
                                        </svg>
                                    </a>
                                <?php endif; ?>

                                <?php if (!empty($member['facebook']['url'])): ?>
                                    <a href="<?php echo esc_url($member['facebook']['url']); ?>" class="social-link facebook"
                                        <?php echo $member['facebook']['is_external'] ? 'target="_blank"' : ''; ?>>
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M18 2H15C13.6739 2 12.4021 2.52678 11.4645 3.46447C10.5268 4.40215 10 5.67392 10 7V10H7V14H10V22H14V14H17L18 10H14V7C14 6.73478 14.1054 6.48043 14.2929 6.29289C14.4804 6.10536 14.7348 6 15 6H18V2Z"
                                                stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                        </svg>
                                    </a>
                                <?php endif; ?>

                                <?php if (!empty($member['instagram']['url'])): ?>
                                    <a href="<?php echo esc_url($member['instagram']['url']); ?>" class="social-link instagram"
                                        <?php echo $member['instagram']['is_external'] ? 'target="_blank"' : ''; ?>>
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M17 2H7C4.23858 2 2 4.23858 2 7V17C2 19.7614 4.23858 22 7 22H17C19.7614 22 22 19.7614 22 17V7C22 4.23858 19.7614 2 17 2Z"
                                                stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path
                                                d="M16 11.37C16.1234 12.2022 15.9813 13.0522 15.5938 13.799C15.2063 14.5458 14.5931 15.1514 13.8416 15.5297C13.0901 15.9079 12.2384 16.0396 11.4078 15.9059C10.5771 15.7723 9.80976 15.3801 9.21484 14.7852C8.61991 14.1902 8.22773 13.4229 8.09406 12.5922C7.9604 11.7615 8.09206 10.9099 8.47032 10.1584C8.84858 9.40685 9.45418 8.79374 10.201 8.40624C10.9478 8.01874 11.7978 7.87659 12.63 8C13.4789 8.12588 14.2648 8.52146 14.8717 9.12831C15.4785 9.73515 15.8741 10.5211 16 11.37Z"
                                                stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path d="M17.5 6.5H17.51" stroke="currentColor" stroke-width="2"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>