<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$team_members = $settings['team_members'];
?>

<div class="modernpress-team modernpress-team-layout-4">
    <div class="team-grid">
        <?php foreach ($team_members as $index => $member): ?>
            <div class="team-member">
                <div class="member-circle">
                    <?php
                    $image_url = !empty($member['image']['url']) ? $member['image']['url'] : $this->default_image;
                    ?>
                    <div class="member-image">
                        <?php
                        // Use Elementor's methods to render the image
                        echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($member, 'image'));
                        ?>
                    </div>
                    <div class="member-overlay">
                        <div class="member-content">
                            <h3 class="member-name"><?php echo esc_html($member['name']); ?></h3>
                            <span class="member-position"><?php echo esc_html($member['position']); ?></span>
                            <div class="member-social">
                                <?php if (!empty($member['linkedin']['url'])): ?>
                                    <a href="<?php echo esc_url($member['linkedin']['url']); ?>" class="social-link linkedin"
                                        <?php echo $member['linkedin']['is_external'] ? 'target="_blank"' : ''; ?>>
                                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path
                                                d="M16 8a6 6 0 0 1 6 6v7h-4v-7a2 2 0 0 0-2-2 2 2 0 0 0-2 2v7h-4v-7a6 6 0 0 1 6-6z">
                                            </path>
                                            <rect x="2" y="9" width="4" height="12"></rect>
                                            <circle cx="4" cy="4" r="2"></circle>
                                        </svg>
                                    </a>
                                <?php endif; ?>

                                <?php if (!empty($member['twitter']['url'])): ?>
                                    <a href="<?php echo esc_url($member['twitter']['url']); ?>" class="social-link twitter"
                                        <?php echo $member['twitter']['is_external'] ? 'target="_blank"' : ''; ?>>
                                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path
                                                d="M23 3a10.9 10.9 0 0 1-3.14 1.53 4.48 4.48 0 0 0-7.86 3v1A10.66 10.66 0 0 1 3 4s-4 9 5 13a11.64 11.64 0 0 1-7 2c9 5 20 0 20-11.5a4.5 4.5 0 0 0-.08-.83A7.72 7.72 0 0 0 23 3z">
                                            </path>
                                        </svg>
                                    </a>
                                <?php endif; ?>

                                <?php if (!empty($member['facebook']['url'])): ?>
                                    <a href="<?php echo esc_url($member['facebook']['url']); ?>" class="social-link facebook"
                                        <?php echo $member['facebook']['is_external'] ? 'target="_blank"' : ''; ?>>
                                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"></path>
                                        </svg>
                                    </a>
                                <?php endif; ?>

                                <?php if (!empty($member['instagram']['url'])): ?>
                                    <a href="<?php echo esc_url($member['instagram']['url']); ?>" class="social-link instagram"
                                        <?php echo $member['instagram']['is_external'] ? 'target="_blank"' : ''; ?>>
                                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <rect x="2" y="2" width="20" height="20" rx="5" ry="5"></rect>
                                            <path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z"></path>
                                            <line x1="17.5" y1="6.5" x2="17.51" y2="6.5"></line>
                                        </svg>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>