<?php
if (!defined('ABSPATH')) {
    exit;
}

$team_members = $settings['team_members'];
?>

<div class="modernpress-team modernpress-team-layout-3">
    <div class="team-grid">
        <?php foreach ($team_members as $member): ?>
            <div class="team-member">
                <?php
                $image_url = !empty($member['image']['url']) ? $member['image']['url'] : $this->default_image;
                ?>
                <div class="member-image">
                    <?php
                    // Use Elementor's methods to render the image
                    echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($member, 'image'));
                    ?>
                    <div class="member-overlay">
                        <div class="member-content">
                            <h3 class="member-name"><?php echo esc_html($member['name']); ?></h3>
                            <span class="member-position"><?php echo esc_html($member['position']); ?></span>
                            <div class="member-social">
                                <?php if (!empty($member['linkedin']['url'])): ?>
                                    <a href="<?php echo esc_url($member['linkedin']['url']); ?>" class="social-link" <?php echo $member['linkedin']['is_external'] ? 'target="_blank"' : ''; ?>>
                                        <svg width="17" height="16" viewBox="0 0 17 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M1.05669 3.16856C0.677069 2.8161 0.488281 2.37982 0.488281 1.86072C0.488281 1.34162 0.678078 0.886132 1.05669 0.53266C1.4363 0.180199 1.92496 0.00346375 2.52367 0.00346375C3.12237 0.00346375 3.59186 0.180199 3.97046 0.53266C4.35008 0.885122 4.53887 1.32849 4.53887 1.86072C4.53887 2.39295 4.34907 2.8161 3.97046 3.16856C3.59085 3.52102 3.10925 3.69775 2.52367 3.69775C1.93809 3.69775 1.4363 3.52102 1.05669 3.16856ZM4.21984 5.19042V15.9965H0.806302V5.19042H4.21984Z"
                                                fill="black" />
                                            <path
                                                d="M15.5825 6.25788C16.3266 7.06581 16.6981 8.17472 16.6981 9.58659V15.8056H13.4562V10.0249C13.4562 9.31289 13.2715 8.75946 12.903 8.36559C12.5344 7.97172 12.0377 7.77377 11.4158 7.77377C10.7939 7.77377 10.2971 7.97071 9.92859 8.36559C9.56007 8.75946 9.37531 9.31289 9.37531 10.0249V15.8056H6.11426V5.16011H9.37531V6.57197C9.70546 6.10135 10.1507 5.7297 10.7101 5.45601C11.2694 5.18232 11.8984 5.04597 12.598 5.04597C13.8439 5.04597 14.8394 5.44994 15.5825 6.25788Z"
                                                fill="black" />
                                        </svg>
                                    </a>
                                <?php endif; ?>
                                <?php if (!empty($member['twitter']['url'])): ?>
                                    <a href="<?php echo esc_url($member['twitter']['url']); ?>" class="social-link" <?php echo $member['twitter']['is_external'] ? 'target="_blank"' : ''; ?>>
                                        <svg width="17" height="16" viewBox="0 0 17 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M0.737958 0.460709L6.95657 8.77732L0.699219 15.5393H2.10791L7.58675 9.61939L12.0131 15.5393H16.806L10.2378 6.75488L16.0625 0.460709H14.6538L9.60859 5.91283L5.53183 0.460709H0.738893H0.737958ZM2.80893 1.49842H5.0103L14.7331 14.5016H12.5318L2.80893 1.49842Z"
                                                fill="black" />
                                        </svg>
                                    </a>
                                <?php endif; ?>
                                <?php if (!empty($member['facebook']['url'])): ?>
                                    <a href="<?php echo esc_url($member['facebook']['url']); ?>" class="social-link" <?php echo $member['facebook']['is_external'] ? 'target="_blank"' : ''; ?>>
                                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"></path>
                                        </svg>
                                    </a>
                                <?php endif; ?>
                                <?php if (!empty($member['instagram']['url'])): ?>
                                    <a href="<?php echo esc_url($member['instagram']['url']); ?>" class="social-link" <?php echo $member['instagram']['is_external'] ? 'target="_blank"' : ''; ?>>
                                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <rect x="2" y="2" width="20" height="20" rx="5" ry="5"></rect>
                                            <path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z"></path>
                                            <line x1="17.5" y1="6.5" x2="17.51" y2="6.5"></line>
                                        </svg>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>