<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$tabs = $settings['tabs'];
?>

<div class="modernpress-tabs modernpress-tabs-layout-3">
    <div class="tabs-wrapper">
        <div class="tabs-navigation">
            <?php foreach ($tabs as $index => $item): ?>
                <div class="tab-title <?php echo $index === 0 ? 'active' : ''; ?>"
                    data-tab="tab-<?php echo esc_attr($index); ?>">
                    <?php if (!empty($item['tab_icon']['value'])): ?>
                        <span class="tab-icon">
                            <?php \Elementor\Icons_Manager::render_icon($item['tab_icon'], ['aria-hidden' => 'true']); ?>
                        </span>
                    <?php endif; ?>
                    <span class="tab-text"><?php echo esc_html($item['tab_title']); ?></span>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <div class="tabs-content">
        <?php foreach ($tabs as $index => $item): ?>
            <div class="tab-content <?php echo $index === 0 ? 'active' : ''; ?>" id="tab-<?php echo esc_attr($index); ?>">
                <div class="content-inner">
                    <?php if (isset($item['tab_image'])): ?>
                        <div class="content-image">
                            <?php
                            // Use Elementor's methods to render the image
                            $image_instance = \Elementor\Group_Control_Image_Size::get_attachment_image_html($item, 'tab_image');
                            echo wp_kses_post($image_instance);
                            ?>
                        </div>
                    <?php endif; ?>
                    <div class="content-text">
                        <div class="content-title">
                            <h3><?php echo esc_html($item['tab_title']); ?></h3>
                        </div>
                        <?php echo wp_kses_post($item['tab_content']); ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>