<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$show_pagination = $settings['show_pagination'] === 'yes';
$show_search = $settings['show_search'] === 'yes';
$rows_per_page = intval($settings['rows_per_page']);
$headers = $settings['table_headers'];
$table_rows = $settings['table_rows'];
?>

<div class="modernpress-table-layout-2">
    <div class="table-header">
        <div class="entries-selector">
            <select class="entries-select" aria-label="Entries per page">
                <?php
                $total_rows = count($table_rows);
                $per_page_options = [5, 10, 25, 50, 100];
                // Add option for all rows
                $per_page_options[] = $total_rows;
                sort($per_page_options);

                foreach ($per_page_options as $option):
                    // Skip if option is greater than total rows
                    if ($option > $total_rows && $option !== $total_rows)
                        continue;
                    ?>
                    <option value="<?php echo esc_attr($option); ?>" <?php selected($rows_per_page, $option); ?>>
                        <?php echo $option === $total_rows ? esc_html('All') : esc_html($option); ?> entries per page
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <?php if ($show_search): ?>
            <div class="table-search">
                <input type="text" placeholder="Search..." aria-label="Search table">
                <svg class="search-icon" width="20" height="20" viewBox="0 0 20 20" fill="none">
                    <path
                        d="M9.16667 15.8333C12.8486 15.8333 15.8333 12.8486 15.8333 9.16667C15.8333 5.48477 12.8486 2.5 9.16667 2.5C5.48477 2.5 2.5 5.48477 2.5 9.16667C2.5 12.8486 5.48477 15.8333 9.16667 15.8333Z"
                        stroke="currentColor" stroke-width="2" />
                    <path d="M17.5 17.5L13.875 13.875" stroke="currentColor" stroke-width="2" stroke-linecap="round" />
                </svg>
            </div>
        <?php endif; ?>
    </div>

    <div class="table-wrapper">
        <table class="modernpress-table">
            <?php if (!empty($headers)): ?>
                <tr class="header-row">
                    <?php foreach ($headers as $header): ?>
                        <th><?php echo esc_html($header['header_text']); ?></th>
                    <?php endforeach; ?>
                </tr>
            <?php endif; ?>

            <?php
            // Count how many headers we have to ensure each row has correct cells
            $header_count = count($headers);

            foreach ($table_rows as $row):
                $cells = !empty($row['cells']) ? $row['cells'] : [];
                ?>
                <tr>
                    <?php
                    // Output cells from the data
                    foreach ($cells as $index => $cell):
                        // Only output cells up to the number of headers
                        if ($index < $header_count):
                            ?>
                            <td><?php echo esc_html($cell['cell_text']); ?></td>
                            <?php
                        endif;
                    endforeach;

                    // If there are fewer cells than headers, add empty cells
                    for ($i = count($cells); $i < $header_count; $i++):
                        ?>
                        <td></td>
                    <?php endfor; ?>
                </tr>
            <?php endforeach; ?>
        </table>
    </div>

    <?php if ($show_pagination): ?>
        <div class="table-footer">
            <div class="table-info">
                <!-- Will be populated by JavaScript -->
            </div>
            <div class="table-pagination">
                <button class="pagination-arrow prev" aria-label="Previous page" disabled>
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M15 19L8 12L15 5" stroke="currentColor" stroke-width="2" stroke-linecap="round" />
                    </svg>
                </button>
                <div class="pagination-numbers">
                    <!-- Will be populated by JavaScript -->
                </div>
                <button class="pagination-arrow next" aria-label="Next page" disabled>
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M9 5L16 12L9 19" stroke="currentColor" stroke-width="2" stroke-linecap="round" />
                    </svg>
                </button>
            </div>
        </div>
    <?php endif; ?>
</div>