<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$social_icons = $settings['social_icons'];

// Social network icons mapping (same as previous layouts)
$icons_map = [
    'facebook' => '<svg width="10" height="16" viewBox="0 0 10 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.49446 3.60529V5.86104H9.28413L8.8424 8.89968H6.49446V15.9006C6.02371 15.9659 5.54208 16 5.0532 16C4.48888 16 3.93472 15.955 3.39506 15.8679V8.89968H0.822266V5.86104H3.39506V3.10103C3.39506 1.38872 4.78265 0 6.49518 0V0.00145253C6.50026 0.00145253 6.50461 0 6.50969 0H9.28486V2.62797H7.4715C6.93257 2.62797 6.49518 3.06548 6.49518 3.60457L6.49446 3.60529Z" fill="black"/>
</svg>',
    'twitter' => '<svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M0.308231 0.518311L7.30416 9.87449L0.264648 17.4817H1.84942L8.01312 10.8218L12.9928 17.4817H18.3848L10.9956 7.59925L17.5483 0.518311H15.9635L10.2877 6.65195L5.70133 0.518311H0.309281H0.308231ZM2.63808 1.68573H5.11461L16.0528 16.3143H13.5763L2.63808 1.68573Z" fill="black"/>
</svg>',
    'instagram' => '<svg width="20" height="18" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.4755 0H5.08805C2.4946 0 0.384766 2.11046 0.384766 4.70467V13.2953C0.384766 15.8895 2.4946 18 5.08805 18H14.4755C17.0689 18 19.1788 15.8895 19.1788 13.2953V4.70467C19.1788 2.11046 17.0689 0 14.4755 0ZM2.04394 4.70467C2.04394 3.02587 3.40975 1.65964 5.08805 1.65964H14.4755C16.1538 1.65964 17.5196 3.02587 17.5196 4.70467V13.2953C17.5196 14.9741 16.1538 16.3404 14.4755 16.3404H5.08805C3.40975 16.3404 2.04394 14.9741 2.04394 13.2953V4.70467Z" fill="black"/>
<path d="M9.78208 13.3751C12.1938 13.3751 14.1569 11.4124 14.1569 8.99892C14.1569 6.58545 12.1948 4.62279 9.78208 4.62279C7.36932 4.62279 5.40723 6.58545 5.40723 8.99892C5.40723 11.4124 7.36932 13.3751 9.78208 13.3751ZM9.78208 6.2835C11.2797 6.2835 12.4978 7.50193 12.4978 8.99998C12.4978 10.498 11.2797 11.7165 9.78208 11.7165C8.28447 11.7165 7.0664 10.498 7.0664 8.99998C7.0664 7.50193 8.28447 6.2835 9.78208 6.2835Z" fill="black"/>
<path d="M14.5616 5.32981C15.211 5.32981 15.7403 4.80142 15.7403 4.15074C15.7403 3.50006 15.212 2.97163 14.5616 2.97163C13.9111 2.97163 13.3828 3.50006 13.3828 4.15074C13.3828 4.80142 13.9111 5.32981 14.5616 5.32981Z" fill="black"/>
</svg>',
    'linkedin' => '<svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M0.667776 3.56464C0.240706 3.16812 0.0283203 2.6773 0.0283203 2.09332C0.0283203 1.50933 0.241842 0.996908 0.667776 0.599252C1.09485 0.202733 1.64459 0.00390625 2.31813 0.00390625C2.99167 0.00390625 3.51984 0.202733 3.94578 0.599252C4.37285 0.995771 4.58523 1.49456 4.58523 2.09332C4.58523 2.69207 4.37171 3.16812 3.94578 3.56464C3.51871 3.96116 2.97691 4.15998 2.31813 4.15998C1.65935 4.15998 1.09485 3.96116 0.667776 3.56464ZM4.22632 5.83923V17.9961H0.386094V5.83923H4.22632Z" fill="black"/>
<path d="M17.0092 7.04012C17.8463 7.94904 18.2642 9.19657 18.2642 10.7849V17.7814H14.6171V11.278C14.6171 10.477 14.4093 9.85439 13.9947 9.41129C13.5801 8.96819 13.0213 8.74549 12.3216 8.74549C11.622 8.74549 11.0631 8.96705 10.6485 9.41129C10.234 9.85439 10.0261 10.477 10.0261 11.278V17.7814H6.35742V5.80513H10.0261V7.39347C10.3975 6.86402 10.8984 6.44591 11.5277 6.13801C12.1569 5.83012 12.8646 5.67673 13.6517 5.67673C15.0533 5.67673 16.1732 6.13119 17.0092 7.04012Z" fill="black"/>
</svg>',
    'youtube' => '<svg width="23" height="16" viewBox="0 0 23 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21.883 4.5153C21.7507 3.23773 21.4659 1.82541 20.4179 1.08321C19.6062 0.507654 18.5393 0.486376 17.5433 0.487558C15.4379 0.48874 13.3313 0.491108 11.2259 0.49229C9.20078 0.494654 7.17568 0.495841 5.15059 0.498205C4.30464 0.499387 3.48231 0.433209 2.69662 0.799582C2.02198 1.11395 1.49385 1.71195 1.17603 2.37733C0.735329 3.30272 0.643177 4.35103 0.590009 5.37451C0.491945 7.23828 0.502578 9.10679 0.619547 10.9694C0.705796 12.3285 0.92437 13.8306 1.97472 14.6969C2.90574 15.4639 4.21957 15.5018 5.42706 15.5029C9.25984 15.5065 13.0938 15.51 16.9278 15.5124C17.4193 15.5136 17.9321 15.5041 18.433 15.4498C19.4184 15.3434 20.3577 15.0609 20.9909 14.3306C21.6301 13.5943 21.7944 12.5696 21.8913 11.5993C22.1276 9.24505 22.1252 6.86836 21.883 4.5153ZM9.00937 11.3003V4.69968L14.7231 7.99939L9.00937 11.3003Z" fill="black"/>
</svg>',
    'pinterest' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 2a10 10 0 0 0-3.16 19.5c-.07-.7-.13-1.77.03-2.55.15-.7.96-4.43.96-4.43s-.25-.5-.25-1.23c0-1.15.67-2 1.5-2 .7 0 1.04.53 1.04 1.17 0 .7-.44 1.77-.68 2.75-.2.82.4 1.5 1.2 1.5 1.45 0 2.57-1.54 2.57-3.77 0-1.97-1.42-3.34-3.44-3.34-2.34 0-3.7 1.76-3.7 3.57 0 .7.27 1.46.6 1.87.07.08.08.15.06.24l-.23.9c-.04.15-.13.18-.28.1-1.05-.48-1.7-2-1.7-3.22 0-2.6 1.88-4.97 5.42-4.97 2.85 0 5.06 2.03 5.06 4.73 0 2.83-1.78 5.1-4.24 5.1-.83 0-1.6-.43-1.87-.94l-.5 1.9c-.18.7-.68 1.57-1 2.1.76.23 1.57.35 2.4.35 4.42 0 8-3.58 8-8s-3.58-8-8-8z"/></svg>',
    'tiktok' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 12a4 4 0 1 0 4 4V4a5 5 0 0 0 5 5"></path></svg>',
    'whatsapp' => '<svg width="23" height="22" viewBox="0 0 23 22" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.8286 15.933C10.5126 15.933 7.00118 12.4194 7 8.10211C7.00118 7.00772 7.89204 6.11778 8.98374 6.11778C9.09598 6.11778 9.20704 6.12724 9.31337 6.14615C9.54731 6.18515 9.76944 6.26433 9.97384 6.3837C10.0034 6.40143 10.0235 6.42981 10.0282 6.4629L10.4842 9.33832C10.4901 9.37259 10.4795 9.40568 10.4571 9.4305C10.2054 9.70942 9.88404 9.91035 9.52605 10.0108L9.35355 10.0593L9.41853 10.2259C10.0069 11.7245 11.205 12.9217 12.7043 13.5126L12.8709 13.5788L12.9193 13.4063C13.0197 13.0482 13.2206 12.7267 13.4994 12.4749C13.5195 12.456 13.5467 12.4466 13.5739 12.4466C13.5798 12.4466 13.5857 12.4466 13.5928 12.4478L16.4674 12.904C16.5016 12.9099 16.53 12.9288 16.5477 12.9583C16.6659 13.1628 16.745 13.3861 16.7852 13.6201C16.8041 13.7241 16.8124 13.8341 16.8124 13.9487C16.8124 15.0419 15.9227 15.9318 14.8286 15.933Z" fill="black"/>
<path d="M22.4819 10.0522C22.2492 7.42136 21.0441 4.98086 19.0887 3.1809C17.1215 1.37031 14.5694 0.372833 11.9004 0.372833C6.04255 0.372833 1.27639 5.1404 1.27639 11C1.27639 12.9666 1.81869 14.8824 2.84541 16.5511L0.555664 21.6213L7.88687 20.8401C9.16171 21.3624 10.511 21.6272 11.8992 21.6272C12.2643 21.6272 12.6389 21.6082 13.0146 21.5692C13.3454 21.5338 13.6798 21.4818 14.0082 21.4156C18.9138 20.4241 22.4949 16.0689 22.5233 11.0567V11C22.5233 10.6809 22.5091 10.3618 22.4808 10.0533L22.4819 10.0522ZM8.16925 18.6146L4.11317 19.0472L5.32421 16.3632L5.08199 16.0382C5.06427 16.0146 5.04655 15.9909 5.02647 15.9638C3.97493 14.5113 3.41962 12.7952 3.41962 11.0012C3.41962 6.32343 7.22405 2.51787 11.9004 2.51787C16.2814 2.51787 19.9949 5.93697 20.3529 10.3015C20.3718 10.5355 20.3824 10.7707 20.3824 11.0024C20.3824 11.0685 20.3812 11.1335 20.38 11.2033C20.2903 15.1164 17.5574 18.4397 13.7341 19.2859C13.4423 19.3509 13.1434 19.4006 12.8456 19.4325C12.5361 19.4679 12.2182 19.4857 11.9028 19.4857C10.7792 19.4857 9.68748 19.2682 8.65603 18.838C8.54142 18.7919 8.42918 18.7423 8.32402 18.6915L8.17044 18.617L8.16925 18.6146Z" fill="black"/>
</svg>',
    'telegram' => '<svg width="21" height="18" viewBox="0 0 21 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M0.60707 8.24779C0.65433 8.22416 0.701612 8.20169 0.747691 8.18042C1.54875 7.80932 2.36044 7.46186 3.17095 7.11439C3.21466 7.11439 3.2879 7.06356 3.32925 7.04702C3.39187 7.01984 3.4545 6.99384 3.51712 6.96666C3.63763 6.91466 3.75815 6.86383 3.87748 6.81183C4.11851 6.70901 4.35834 6.60621 4.59936 6.50339C5.08023 6.29775 5.5611 6.09211 6.04197 5.88528C7.00371 5.474 7.96665 5.06151 8.92839 4.65023C9.89013 4.23895 10.853 3.82649 11.8148 3.4152C12.7765 3.00392 13.7394 2.59146 14.7012 2.18018C15.6629 1.7689 16.6259 1.35644 17.5876 0.945155C17.8015 0.852971 18.033 0.715873 18.2622 0.67569C18.4548 0.641417 18.6427 0.575244 18.8364 0.538606C19.2039 0.468877 19.6091 0.440508 19.9612 0.592967C20.0829 0.64615 20.1952 0.720591 20.2885 0.813957C20.7351 1.25597 20.6725 1.98164 20.578 2.60329C19.9199 6.93594 19.2618 11.2698 18.6025 15.6024C18.5127 16.1969 18.3898 16.8493 17.9208 17.2251C17.5238 17.543 16.959 17.5785 16.4687 17.4437C15.9784 17.3078 15.546 17.023 15.1218 16.7429C13.3625 15.5776 11.6021 14.4123 9.84287 13.247C9.42462 12.9704 8.95912 12.6088 8.96384 12.1065C8.9662 11.804 9.14696 11.5345 9.33127 11.2946C10.8601 9.29961 13.066 7.92869 14.7071 6.02592C14.9387 5.75764 15.1206 5.27309 14.8028 5.11826C14.6138 5.02608 14.3963 5.15133 14.2239 5.2707C12.0546 6.77755 9.88659 8.28559 7.71735 9.79245C7.00964 10.2841 6.26766 10.7899 5.41461 10.9105C4.65136 11.0192 3.88339 10.8065 3.14496 10.589C2.52585 10.407 1.90791 10.2203 1.29235 10.0276C0.96507 9.926 0.627159 9.81608 0.374318 9.58562C0.121478 9.35516 -0.0238272 8.96754 0.128586 8.66026C0.224288 8.46762 0.409786 8.34589 0.604734 8.24661L0.60707 8.24779Z" fill="black"/>
</svg>',
    'discord' => '<svg width="26" height="20" viewBox="0 0 26 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M21.2925 2.25442C19.74 1.54176 18.0765 1.01702 16.3361 0.716834C16.3042 0.710924 16.2723 0.725115 16.2569 0.754661C16.0431 1.13522 15.8056 1.63277 15.6402 2.02278C13.7687 1.74268 11.9067 1.74268 10.073 2.02278C9.9064 1.62332 9.66064 1.13522 9.44561 0.754661C9.42907 0.726296 9.39718 0.712106 9.36646 0.716834C7.62729 1.01702 5.96257 1.54176 4.41008 2.25442C4.39708 2.26033 4.38526 2.26978 4.37699 2.28278C1.22002 7.00071 0.355144 11.6028 0.779302 16.1482C0.781665 16.1707 0.793482 16.1919 0.811205 16.2049C2.89419 17.7354 4.91221 18.6644 6.89241 19.2801C6.92431 19.2896 6.95739 19.2778 6.97747 19.2518C7.44534 18.6124 7.8636 17.9375 8.22159 17.2272C8.24286 17.1859 8.22158 17.1362 8.17905 17.1197C7.51623 16.868 6.88648 16.5619 6.27919 16.2144C6.23074 16.186 6.22722 16.1175 6.27094 16.0844C6.39854 15.9887 6.52613 15.8894 6.64783 15.7889C6.67028 15.77 6.70099 15.7665 6.72698 15.7783C10.7122 17.5983 15.027 17.5983 18.965 15.7783C18.9909 15.7653 19.0217 15.77 19.0441 15.7877C19.1658 15.8882 19.2934 15.9887 19.4222 16.0844C19.4659 16.1175 19.4636 16.186 19.4151 16.2144C18.809 16.569 18.1781 16.8691 17.5141 17.1197C17.4704 17.1362 17.4514 17.1859 17.4727 17.2284C17.839 17.9375 18.256 18.6112 18.7156 19.2518C18.7346 19.2789 18.7688 19.2908 18.8007 19.2813C20.7904 18.6656 22.8084 17.7366 24.8913 16.2061C24.9091 16.1931 24.9209 16.1719 24.9233 16.1506C25.4313 10.8961 24.0726 6.33179 21.3232 2.28515C21.3161 2.27215 21.3055 2.26151 21.2913 2.2556L21.2925 2.25442ZM8.81468 13.3803C7.61428 13.3803 6.62657 12.2789 6.62657 10.9256C6.62657 9.57243 7.59655 8.47094 8.81468 8.47094C10.0328 8.47094 11.0229 9.58307 11.0028 10.9256C11.0028 12.2789 10.0328 13.3803 8.81468 13.3803ZM16.9068 13.3803C15.7064 13.3803 14.7187 12.2789 14.7187 10.9256C14.7187 9.57243 15.6886 8.47094 16.9068 8.47094C18.1249 8.47094 19.115 9.58307 19.0949 10.9256C19.0949 12.2789 18.1355 13.3803 16.9068 13.3803Z" fill="black"/>
</svg>',
    'github' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M9 19c-5 1.5-5-2.5-7-3m14 6v-3.87a3.37 3.37 0 0 0-.94-2.61c3.14-.35 6.44-1.54 6.44-7A5.44 5.44 0 0 0 20 4.77 5.07 5.07 0 0 0 19.91 1S18.73.65 16 2.48a13.38 13.38 0 0 0-7 0C6.27.65 5.09 1 5.09 1A5.07 5.07 0 0 0 5 4.77a5.44 5.44 0 0 0-1.5 3.78c0 5.42 3.3 6.61 6.44 7A3.37 3.37 0 0 0 9 18.13V22"></path></svg>',
    'dribbble' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><path d="M8.56 2.75c4.37 6.03 6.02 9.42 8.03 17.72m2.54-15.38c-3.72 4.35-8.94 5.66-16.88 5.85m19.5 1.9c-3.5-.93-6.63-.82-8.94 0-2.58.92-5.01 2.86-7.44 6.32"></path></svg>',
    'behance' => '<svg width="26" height="16" viewBox="0 0 26 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.2094 8.82967C10.8253 8.34782 10.3854 7.97907 9.89286 7.72962C10.3281 7.46469 10.7029 7.13935 11.0127 6.75202C11.5347 6.0982 11.7995 5.27857 11.7995 4.31488C11.7995 3.51077 11.5873 2.77175 11.1676 2.11948C10.7494 1.46721 10.1267 0.943528 9.31668 0.562391C8.52365 0.189001 7.56799 0 6.47913 0H0.285156V16H6.76412C7.82511 16 8.77302 15.8063 9.57999 15.4252C10.4024 15.0379 11.0437 14.4956 11.4836 13.8154C11.925 13.1322 12.1496 12.356 12.1496 11.5085C12.1496 10.5154 11.8336 9.61518 11.2094 8.83122V8.82967ZM7.91959 5.91381C7.53701 6.22367 6.97787 6.38171 6.26074 6.38171H3.58117V2.83684H6.26074C6.97477 2.83684 7.53082 2.99951 7.91339 3.32177C8.28048 3.63009 8.4586 4.05617 8.4586 4.62013C8.4586 5.18409 8.28202 5.62098 7.91959 5.91381ZM3.58117 9.2201H6.45744C7.2102 9.2201 7.78948 9.4029 8.22781 9.77939C8.64756 10.1404 8.85201 10.6192 8.85201 11.2451C8.85201 11.871 8.66305 12.3126 8.27273 12.6426C7.86847 12.985 7.28764 13.1585 6.54418 13.1585H3.58117V9.2201Z" fill="black"/>
<path d="M24.8045 6.15396C24.3058 5.25224 23.5995 4.54112 22.7042 4.04223C21.8105 3.54334 20.7774 3.29079 19.6374 3.29079C18.4975 3.29079 17.3869 3.55107 16.4715 4.0639C15.5546 4.57828 14.8328 5.31731 14.3279 6.26395C13.8229 7.20905 13.5674 8.31838 13.5674 9.56095C13.5674 10.8035 13.8307 11.9144 14.3511 12.8579C14.8715 13.803 15.5995 14.5467 16.5164 15.0673C17.4318 15.5879 18.482 15.8513 19.639 15.8513C21.0593 15.8513 22.2659 15.4902 23.2262 14.7791C24.1865 14.068 24.8587 13.1415 25.2258 12.0275L25.2521 11.9485H22.4425L22.4254 11.9826C21.8849 13.078 20.9478 13.6326 19.6374 13.6326C18.7252 13.6326 17.9445 13.3429 17.3172 12.7743C16.7054 12.2181 16.3538 11.4744 16.2717 10.5618H25.4597L25.4674 10.5107C25.5263 10.1435 25.5557 9.72826 25.5557 9.27741C25.5557 8.10611 25.3032 7.05567 24.8045 6.15396ZM17.3606 6.31509C17.9585 5.78057 18.688 5.511 19.5275 5.511C20.4553 5.511 21.2436 5.78523 21.8709 6.3275C22.4812 6.85428 22.8049 7.5623 22.8328 8.42992H16.2981C16.422 7.54835 16.7798 6.83722 17.3621 6.31665L17.3606 6.31509Z" fill="black"/>
<path d="M22.6206 0.367203H16.501V1.8174H22.6206V0.367203Z" fill="black"/>
</svg>',
];

// Brand colors mapping
$brand_colors = [
    'facebook' => '#1877F2',
    'twitter' => '#1DA1F2',
    'instagram' => '#E4405F',
    'linkedin' => '#0A66C2',
    'youtube' => '#FF0000',
    'pinterest' => '#BD081C',
    'tiktok' => '#000000',
    'whatsapp' => '#25D366',
    'telegram' => '#0088cc',
    'discord' => '#5865F2',
    'github' => '#181717',
    'dribbble' => '#EA4C89',
    'behance' => '#1769FF',
];
?>

<div class="modernpress-social-icons modernpress-social-icons-layout-3">
    <?php foreach ($social_icons as $item):
        $network = $item['social_network'];
        $url = !empty($item['link']['url']) ? $item['link']['url'] : '#';
        $target = !empty($item['link']['is_external']) ? ' target="_blank"' : '';
        $nofollow = !empty($item['link']['nofollow']) ? ' rel="nofollow"' : '';

        // You can define brand colors in your widget class or include them here
        $brand_colors = [
            'facebook' => '#3b5998',
            'twitter' => '#1da1f2',
            'instagram' => '#e1306c',
            'linkedin' => '#0077b5',
            'youtube' => '#ff0000',
            'pinterest' => '#bd081c',
            'tiktok' => '#000000',
            'whatsapp' => '#25d366',
            'telegram' => '#0088cc',
            'discord' => '#5865f2',
            'github' => '#333333',
            'dribbble' => '#ea4c89',
            'behance' => '#1769ff',
        ];

        $brand_color = isset($brand_colors[$network]) ? $brand_colors[$network] : '#000000';
        ?>
        <a href="<?php echo esc_url($url); ?>"
            class="social-icon-link elementor-repeater-item-<?php echo esc_attr($item['_id']); ?>" <?php echo esc_attr($target) . ' ' . esc_attr($nofollow); ?> data-network="<?php echo esc_attr($network); ?>"
            aria-label="<?php echo esc_attr(ucfirst($network)); ?>"
            style="--brand-color: <?php echo esc_attr($brand_color); ?>">
            <span class="social-icon">
                <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']); ?>
            </span>
        </a>
    <?php endforeach; ?>
</div>