<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$social_icons = $settings['social_icons'];
?>

<div class="modernpress-social-icons modernpress-social-icons-layout-2">
    <?php foreach ($social_icons as $item):
        $network = $item['social_network'];
        $url = !empty($item['link']['url']) ? $item['link']['url'] : '#';
        $target = !empty($item['link']['is_external']) ? ' target="_blank"' : '';
        $nofollow = !empty($item['link']['nofollow']) ? ' rel="nofollow"' : '';
        ?>
        <a href="<?php echo esc_url($url); ?>"
            class="social-icon-link elementor-repeater-item-<?php echo esc_attr($item['_id']); ?>" <?php echo esc_attr($target) . ' ' . esc_attr($nofollow); ?> data-network="<?php echo esc_attr($network); ?>"
            aria-label="<?php echo esc_attr(ucfirst($network)); ?>">
            <span class="social-icon">
                <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']); ?>
            </span>
        </a>
    <?php endforeach; ?>
</div>