<?php
/**
 * Social Icons Widget - Layout 1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$social_icons = $settings['social_icons'] ?? [];

if (!empty($social_icons)):
    ?>
    <div class="modernpress-social-icons modernpress-social-icons-layout-1">
        <?php foreach ($social_icons as $index => $item):
            $network = $item['social_network'];
            $link_attrs = '';

            if (!empty($item['link']['url'])) {
                $this->add_link_attributes('link_' . $index, $item['link']);
                $link_attrs = $this->get_render_attribute_string('link_' . $index);
            }
            ?>
            <div class="modernpress-social-icon-wrapper elementor-repeater-item-<?php echo esc_attr($item['_id']); ?>">
                <a class="social-icon" <?php echo wp_kses_post($link_attrs); ?> aria-label="<?php echo esc_attr($network); ?>">
                    <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']); ?>
                </a>
            </div>
        <?php endforeach; ?>
    </div>
    <?php
endif;
?>