<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$slides = $settings['slides'];
$slider_id = $this->get_id();
?>

<div class="modernpress-slider modernpress-slider-layout-3">
    <div class="slider-header">
        <?php if ($settings['navigation'] === 'yes'): ?>
            <div class="slider-navigation">
                <div class="swiper-button-prev">
                    <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="-0.5" y="0.5" width="39" height="39" rx="19.5" transform="matrix(-1 0 0 1 39 0)"
                            fill="white" />
                        <rect x="-0.5" y="0.5" width="39" height="39" rx="19.5" transform="matrix(-1 0 0 1 39 0)"
                            stroke="#E3E7F1" />
                        <path d="M12 20L28 20M12 20L16.9999 25M12 20L17 15" stroke="#0D3FB0" stroke-width="1.5" />
                    </svg>
                </div>
                <div class="swiper-button-next">
                    <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="0.5" y="0.5" width="39" height="39" rx="19.5" fill="white" />
                        <rect x="0.5" y="0.5" width="39" height="39" rx="19.5" stroke="#E3E7F1" />
                        <path d="M28 20L12 20M28 20L23.0001 25M28 20L23 15" stroke="#0D3FB0" stroke-width="1.5" />
                    </svg>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <div class="swiper">
        <div class="swiper-wrapper">
            <?php foreach ($slides as $slide): ?>
                <div class="swiper-slide">
                    <div class="slide-inner">
                        <?php
                        $image_url = !empty($slide['image']['url']) ? $slide['image']['url'] : $this->default_image;
                        $target = isset($slide['button_link']['is_external']) ? $slide['button_link']['is_external'] ? ' target="_blank"' : '' : '';
                        $nofollow = isset($slide['button_link']['nofollow']) ? $slide['button_link']['nofollow'] ? ' rel="nofollow"' : '' : '';
                        ?>

                        <div class="slide-image">
                            <?php
                            // Use Elementor's methods to render the image
                            echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($slide, 'image'));
                            ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <?php if ($settings['pagination'] === 'yes'): ?>
        <div class="slider-footer">
            <div class="swiper-pagination"></div>
        </div>
    <?php endif; ?>
</div>