<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$slides = $settings['slides'];
$slider_id = $this->get_id();
?>

<div class="modernpress-slider modernpress-slider-layout-1">
    <!-- Slider main container -->
    <div class="swiper mySwiper">
        <!-- Additional required wrapper -->
        <div class="swiper-wrapper">
            <?php foreach ($slides as $slide): ?>
                <div class="swiper-slide">
                    <?php
                    $image_url = !empty($slide['image']['url']) ? $slide['image']['url'] : $this->default_image;
                    $target = $slide['button_link']['is_external'] ? ' target="_blank"' : '';
                    $nofollow = $slide['button_link']['nofollow'] ? ' rel="nofollow"' : '';
                    ?>

                    <div class="slide-image">
                        <?php
                        // Use Elementor's methods to render the image
                        echo wp_kses_post(\Elementor\Group_Control_Image_Size::get_attachment_image_html($slide, 'image'));
                        ?>
                    </div>
                    <?php if ($slide['title']): ?>
                        <div class="slide-content">
                            <?php if ($slide['title']): ?>
                                <h2 class="slide-title"><?php echo esc_html($slide['title']); ?></h2>
                            <?php endif; ?>

                            <?php if ($slide['description']): ?>
                                <div class="slide-description"><?php echo wp_kses_post($slide['description']); ?></div>
                            <?php endif; ?>

                            <?php if ($slide['button_text'] && $slide['button_link']['url']): ?>
                                <a href="<?php echo esc_url($slide['button_link']['url']); ?>" class="slide-button" <?php echo esc_attr($target) . ' ' . esc_attr($nofollow); ?>>
                                    <?php echo esc_html($slide['button_text']); ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>

        <?php if ($settings['navigation'] === 'yes'): ?>
            <!-- Navigation arrows -->
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        <?php endif; ?>

        <?php if ($settings['pagination'] === 'yes'): ?>
            <!-- Pagination -->
            <div class="swiper-pagination"></div>
        <?php endif; ?>
    </div>
</div>