<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
?>

<div class="modernpress-search-container">
    <div class="modernpress-search-wrapper">
        <div class="search-icon">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none"
                stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <circle cx="11" cy="11" r="8"></circle>
                <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
            </svg>
        </div>
        <input type="text" class="modernpress-search-input"
            placeholder="<?php echo esc_attr($settings['placeholder']); ?>"
            data-results-limit="<?php echo esc_attr($settings['results_limit']); ?>">
        <?php if ($settings['enable_filter'] === 'yes'): ?>
            <div class="filter-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <polygon points="22 3 2 3 10 12.46 10 19 14 21 14 12.46 22 3"></polygon>
                </svg>
            </div>

        <?php endif; ?>
    </div>
    <div class="modernpress-search-results"></div>
</div>