<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Using $post_settings passed from the main widget
$post_id = $post_settings['post_id'];
$title = $post_settings['title'];
$date = $post_settings['date'];
$categories = $post_settings['categories'];
$excerpt = $post_settings['excerpt'];
$image = $post_settings['image'];
$permalink = $post_settings['permalink'];
?>

<div class="modernpress-post modernpress-post-layout-9">
    <a href="<?php echo esc_url($permalink); ?>" class="modernpress-post-link">
        <div class="modernpress-post-background">
            <?php
            if (has_post_thumbnail($post_id)) {
                echo get_the_post_thumbnail($post_id, 'medium_large');
            } else {
                echo '<div class="elementor-placeholder" style="background-image: url(' . esc_url(\Elementor\Utils::get_placeholder_image_src()) . ');"></div>';
            }
            ?>
        </div>

        <div class="modernpress-post-overlay"></div>

        <div class="modernpress-post-content">
            <?php if (!empty($categories)): ?>
                <div class="modernpress-post-categories">
                    <?php foreach ($categories as $category): ?>
                        <span class="category-tag">
                            <?php echo esc_html($category->name); ?>
                        </span>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <h3 class="modernpress-post-title">
                <?php echo esc_html($title); ?>
            </h3>


        </div>
    </a>
</div>