<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Using $post_settings passed from the main widget
$post_id = $post_settings['post_id'];
$title = $post_settings['title'];
$date = $post_settings['date'];
$categories = $post_settings['categories'];
$excerpt = $post_settings['excerpt'];
$image = $post_settings['image'];
$permalink = $post_settings['permalink'];

// Get author information
$author_id = get_post_field('post_author', $post_id);
$author_name = get_the_author_meta('display_name', $author_id);
$author_avatar = get_avatar_url($author_id, ['size' => 100]);
?>

<div class="modernpress-post modernpress-post-layout-7">
    <div class="modernpress-post-image">
        <a href="<?php echo esc_url($permalink); ?>">
            <?php
            if (has_post_thumbnail($post_id)) {
                echo get_the_post_thumbnail($post_id, 'medium_large');
            } else {
                echo '<div class="elementor-placeholder" style="background-image: url(' . esc_url(\Elementor\Utils::get_placeholder_image_src()) . ');"></div>';
            }
            ?>
        </a>
    </div>

    <div class="modernpress-post-content">
        <div class="modernpress-post-author-meta">
            <div class="modernpress-post-author-details">
                <span class="modernpress-post-date"><?php echo esc_html($date); ?></span>
                <span class="modernpress-post-dot">•</span>
                <span class="modernpress-post-author-name"><?php echo esc_html($author_name); ?></span>
            </div>
            <div class="modernpress-post-read-more">
                <a href="<?php echo esc_url($permalink); ?>" class="read-more-link">
                    <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1 11L11 1M11 1H1M11 1V11" stroke="#101828" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round" />
                    </svg>
                </a>
            </div>
        </div>

        <h3 class="modernpress-post-title">
            <a href="<?php echo esc_url($permalink); ?>">
                <?php echo esc_html($title); ?>
            </a>
        </h3>

        <?php if ($excerpt): ?>
            <div class="modernpress-post-excerpt">
                <?php echo wp_kses_post(wp_trim_words($excerpt, 10)); ?>
            </div>
        <?php endif; ?>

        <?php if (!empty($categories)): ?>
            <div class="modernpress-post-categories">
                <?php foreach ($categories as $category): ?>
                    <a href="<?php echo esc_url(get_category_link($category->term_id)); ?>" class="category-tag">
                        <?php echo esc_html($category->name); ?>
                    </a>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>