<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Using $post_settings passed from the main widget
$post_id = $post_settings['post_id'];
$title = $post_settings['title'];
$date = $post_settings['date'];
$categories = $post_settings['categories'];
$excerpt = $post_settings['excerpt'];
$image = $post_settings['image'];
$permalink = $post_settings['permalink'];
?>

<div class="modernpress-post modernpress-post-layout-3">
    <div class="modernpress-post-image">
        <a href="<?php echo esc_url($permalink); ?>">
            <?php
            if (has_post_thumbnail($post_id)) {
                echo get_the_post_thumbnail($post_id, 'medium_large');
            } else {
                echo '<div class="elementor-placeholder" style="background-image: url(' . esc_url(\Elementor\Utils::get_placeholder_image_src()) . ');"></div>';
            }
            ?>
        </a>
    </div>

    <div class="modernpress-post-content">
        <div class="modernpress-post-meta">
            <?php if (!empty($categories)): ?>
                <div class="modernpress-post-categories">
                    <?php foreach ($categories as $category): ?>
                        <a href="<?php echo esc_url(get_category_link($category->term_id)); ?>" class="category-tag">
                            <?php echo esc_html($category->name); ?>
                        </a>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

        <h3 class="modernpress-post-title">
            <a href="<?php echo esc_url($permalink); ?>">
                <?php echo esc_html($title); ?>
            </a>
        </h3>

        <?php if ($excerpt): ?>
            <div class="modernpress-post-excerpt">
                <?php echo wp_kses_post(wp_trim_words($excerpt, 20)); ?>
            </div>
        <?php endif; ?>
    </div>
</div>