<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$post_id = $post_settings['post_id'];
$title = $post_settings['title'];
$date = $post_settings['date'];
$categories = $post_settings['categories'];
$excerpt = $post_settings['excerpt'];
$image = $post_settings['image'];
$permalink = $post_settings['permalink'];

$author_id = get_post_field('post_author', $post_id);
$author_name = get_the_author_meta('display_name', $author_id);
$author_avatar = get_avatar_url($author_id, ['size' => 100]);

$is_featured = isset($featured) && $featured;
?>

<div class="modernpress-post modernpress-post-layout-10 <?php echo $is_featured ? 'featured-post' : 'regular-post'; ?>">
    <a href="<?php echo esc_url($permalink); ?>" class="modernpress-post-link">
        <div class="modernpress-post-image">
            <?php
            if (has_post_thumbnail($post_id)) {
                echo get_the_post_thumbnail($post_id, 'medium_large');
            } else {
                echo '<div class="elementor-placeholder" style="background-image: url(' . esc_url(\Elementor\Utils::get_placeholder_image_src()) . ');"></div>';
            }
            ?>
            <div class="modernpress-post-overlay"></div>
        </div>

        <div class="modernpress-post-content">
            <?php if (!empty($categories)): ?>
                <div class="modernpress-post-categories">
                    <?php foreach ($categories as $category): ?>
                        <span class="category-tag">
                            <?php echo esc_html($category->name); ?>
                        </span>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>



            <h3 class="modernpress-post-title">
                <?php echo esc_html($title); ?>
            </h3>


        </div>
    </a>
</div>